/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.statemachine;

import com.teradata.jdbc.jdbc_4.ParameterProperties;
import com.teradata.jdbc.jdbc_4.TDPreparedStatement;
import com.teradata.jdbc.jdbc_4.parcel.DataInfoField;
import com.teradata.jdbc.jdbc_4.parcel.DataInfoParcel;
import com.teradata.jdbc.jdbc_4.parcel.FullContentMetadataItem;
import com.teradata.jdbc.jdbc_4.parcel.IndicDataParcel;
import com.teradata.jdbc.jdbc_4.parcel.OptionsParcel;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.parcel.ResponseParcel;
import com.teradata.jdbc.jdbc_4.parcel.StatementInfoEndParcel;
import com.teradata.jdbc.jdbc_4.parcel.StatementInfoParcel;
import com.teradata.jdbc.jdbc_4.statemachine.PreparedIndicMultiPartProtocol;
import com.teradata.jdbc.jdbc_4.statemachine.StatementSendState;
import com.teradata.jdbc.jdbc_4.util.JDBC4Constants;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;

public class PreparedIndicProtocol {
    protected StatementSendState sendState;
    protected ParameterProperties paramProperties;

    public PreparedIndicProtocol(StatementSendState statementSendState, ParameterProperties parameterProperties) {
        this.sendState = statementSendState;
        this.paramProperties = parameterProperties;
    }

    void initDataInfoParcel() throws SQLException {
        if (this.paramProperties != null && this.paramProperties.getNumberOfInAndInOutParams() > 0) {
            DataInfoField[] dataInfoFieldArray = this.paramProperties.getDataInfoFields();
            TDPreparedStatement tDPreparedStatement = (TDPreparedStatement)this.sendState.getController().getStatement();
            ArrayList arrayList = tDPreparedStatement.getParameterMarkerMetaData();
            if (arrayList != null) {
                Iterator iterator = arrayList.iterator();
                for (int i = 0; iterator.hasNext() && i < dataInfoFieldArray.length; ++i) {
                    FullContentMetadataItem fullContentMetadataItem = (FullContentMetadataItem)iterator.next();
                    if (448 != JDBC4Constants.getTDBasicType(fullContentMetadataItem.getDataType()) || 448 != JDBC4Constants.getTDBasicType(dataInfoFieldArray[i].getType()) || fullContentMetadataItem.getCharsetCode() != 1 && fullContentMetadataItem.getCharsetCode() != 2 || fullContentMetadataItem.isExpression() != 78 || fullContentMetadataItem.getSPParameterDirection() != 85 || dataInfoFieldArray[i].getLength() >= 32000L) continue;
                    dataInfoFieldArray[i].setLength(32000);
                }
            }
            if (this.sendState.getController().getSession().isStatementInfoRequestSupported()) {
                this.sendState.getPacket().addParcel(new StatementInfoParcel(this.sendState.getController().getSession(), this.sendState.isAltHeader(), dataInfoFieldArray, this.paramProperties.getNumberOfInAndInOutParams(), this.paramProperties.getNumOfParamsAndAttributes() - this.paramProperties.getNumberOfOutParams()));
                this.sendState.getPacket().addParcel(new StatementInfoEndParcel(this.sendState.getController().getSession(), this.sendState.isAltHeader()));
                return;
            }
            DataInfoParcel dataInfoParcel = this.getDataInfoParcel();
            dataInfoParcel.setFields(dataInfoFieldArray);
            this.sendState.getPacket().addParcel(dataInfoParcel);
        }
    }

    void initIndicData() throws SQLException {
        if (this.paramProperties != null && this.paramProperties.getNumberOfInAndInOutParams() > 0) {
            ParameterProperties.ParameterSet parameterSet = this.paramProperties.getParameterSet();
            IndicDataParcel indicDataParcel = this.getIndicDataParcel();
            indicDataParcel.setParameters(parameterSet);
            indicDataParcel.setNullIndicatorBits(parameterSet.getNullIndicatorBits());
            this.sendState.getPacket().addParcel(indicDataParcel);
            this.paramProperties.setNextParameterSet();
        }
    }

    protected DataInfoParcel getDataInfoParcel() throws SQLException {
        return new DataInfoParcel(this.sendState.isAltHeader(), this.paramProperties.getNumberOfInAndInOutParams(), this.sendState.getController().getSession());
    }

    protected IndicDataParcel getIndicDataParcel() throws SQLException {
        int n = this.paramProperties.getParameterSet().getDataSize() + this.paramProperties.getParameterSet().getNullIndicatorBitsSize();
        return new IndicDataParcel(n, this.sendState.getController().getSession(), this.sendState.isAltHeader());
    }

    protected int getBaseSize(boolean bl) throws SQLException {
        int n = 52;
        n += OptionsParcel.standardOptionsParcelLength(this.sendState.getController().getSession());
        n += 4 + this.sendState.text.length;
        if (this.paramProperties != null && this.paramProperties.getNumberOfInAndInOutParams() > 0) {
            n += this.sendState.getController().getSession().isStatementInfoRequestSupported() ? StatementInfoParcel.getParcelLength(bl, this.paramProperties.getNumOfParamsAndAttributes(), this.paramProperties.getDataInfoSize()) + StatementInfoEndParcel.calculateHeaderLength(bl) : (this instanceof PreparedIndicMultiPartProtocol ? 8 : 6) + (bl ? 4 : 0) + this.paramProperties.getDataInfoSize();
        }
        n += ResponseParcel.LENGTH;
        return n += bl ? 12 : 0;
    }

    protected int getDataParcelsHeaderLength(boolean bl) {
        return Parcel.calculateHeaderLength(bl);
    }

    protected int getSize() throws SQLException {
        boolean bl = this.sendState.getController().getSession().isAphSupported();
        int n = this.getBaseSize(bl);
        if (this.paramProperties != null && this.paramProperties.getNumberOfInAndInOutParams() > 0) {
            n += this.getDataParcelsHeaderLength(bl) + this.paramProperties.getDataSize();
        }
        return n;
    }
}

