/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc;

import com.teradata.jdbc.jdbc_4.ColumnProperties;
import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.parcel.PrepInfoParcel;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

public class TeraResultSetMetaData
implements ResultSetMetaData {
    private TDSession m_session;
    private PrepInfoParcel prepInfoParcel;
    private int activityType;
    private ArrayList columnProperties = new ArrayList();
    private ArrayList deserializationProperties = new ArrayList();

    public TeraResultSetMetaData(TDSession tDSession) {
        this.m_session = tDSession;
    }

    public void addColumnProperties(ColumnProperties columnProperties, boolean bl) {
        this.deserializationProperties.add(columnProperties);
        if (bl) {
            this.columnProperties.add(columnProperties);
        }
    }

    public ColumnProperties getColumnProperties(int n) throws SQLException {
        if (n < 1 || n > this.columnProperties.size()) {
            throw ErrorFactory.makeDriverJDBCException("TJ127", Integer.toString(n));
        }
        return (ColumnProperties)this.columnProperties.get(n - 1);
    }

    public ColumnProperties getDeserializationProperties(int n) {
        return n <= this.deserializationProperties.size() ? (ColumnProperties)this.deserializationProperties.get(n - 1) : null;
    }

    public PrepInfoParcel getPrepInfoParcel() {
        return this.prepInfoParcel;
    }

    public int getActivityType() {
        return this.activityType;
    }

    public void setPrepInfoParcel(PrepInfoParcel prepInfoParcel) {
        this.prepInfoParcel = prepInfoParcel;
    }

    public void setActivityType(int n) {
        this.activityType = n;
    }

    @Override
    public int getColumnCount() {
        return this.columnProperties.size();
    }

    private boolean shouldUseColumnProperties() {
        return this.m_session == null || this.m_session.isStatementInfoSupported() && (this.m_session.getCompatDBS() == 0 || this.m_session.getCompatDBS() == 1);
    }

    @Override
    public boolean isAutoIncrement(int n) throws SQLException {
        ColumnProperties columnProperties = this.getColumnProperties(n);
        if (this.shouldUseColumnProperties()) {
            return columnProperties.isAutoIncrement();
        }
        if (this.m_session.getCompatDBS() == 0 || this.m_session.getCompatIsAutoInc() == 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ372", "COMPAT_ISAUTOINC");
        }
        return this.m_session.getCompatIsAutoInc() == 1;
    }

    @Override
    public boolean isCaseSensitive(int n) throws SQLException {
        return this.getColumnProperties(n).caseSensitive();
    }

    @Override
    public boolean isSearchable(int n) throws SQLException {
        ColumnProperties columnProperties = this.getColumnProperties(n);
        if (this.shouldUseColumnProperties()) {
            return columnProperties.isSearchable();
        }
        if (this.m_session.getCompatDBS() == 0 || this.m_session.getCompatIsSearch() == 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ372", "COMPAT_ISSEARCH");
        }
        return this.m_session.getCompatIsSearch() == 1;
    }

    @Override
    public boolean isCurrency(int n) throws SQLException {
        ColumnProperties columnProperties = this.getColumnProperties(n);
        if (this.shouldUseColumnProperties()) {
            return columnProperties.isCurrency();
        }
        if (this.m_session.getCompatDBS() == 0 || this.m_session.getCompatIsCurrency() == 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ372", "COMPAT_ISCURRENCY");
        }
        return this.m_session.getCompatIsCurrency() == 1;
    }

    @Override
    public int isNullable(int n) throws SQLException {
        return this.getColumnProperties(n).getNullable();
    }

    @Override
    public boolean isSigned(int n) throws SQLException {
        ColumnProperties columnProperties = this.getColumnProperties(n);
        if (this.shouldUseColumnProperties()) {
            return columnProperties.isSigned();
        }
        if (this.m_session.getCompatDBS() == 0 || this.m_session.getCompatIsSigned() == 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ372", "COMPAT_ISSIGNED");
        }
        return this.m_session.getCompatIsSigned() == 1;
    }

    @Override
    public int getColumnDisplaySize(int n) throws SQLException {
        return this.getColumnProperties(n).getColumnDisplaySize();
    }

    @Override
    public String getColumnLabel(int n) throws SQLException {
        return this.getColumnProperties(n).getColumnLabel();
    }

    @Override
    public String getColumnName(int n) throws SQLException {
        return this.getColumnProperties(n).getColumnName();
    }

    @Override
    public String getSchemaName(int n) throws SQLException {
        ColumnProperties columnProperties = this.getColumnProperties(n);
        if (this.shouldUseColumnProperties()) {
            return columnProperties.getSchemaName();
        }
        if (this.m_session.getCompatDBS() == 0 || this.m_session.getCompatGetSchema() == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ372", "COMPAT_GETSCHEMA");
        }
        return this.m_session.getCompatGetSchema();
    }

    @Override
    public int getPrecision(int n) throws SQLException {
        return this.getColumnProperties(n).getPrecision();
    }

    @Override
    public int getScale(int n) throws SQLException {
        return this.getColumnProperties(n).getScale();
    }

    @Override
    public String getTableName(int n) throws SQLException {
        ColumnProperties columnProperties = this.getColumnProperties(n);
        if (this.shouldUseColumnProperties()) {
            return columnProperties.getTableName();
        }
        if (this.m_session.getCompatDBS() == 0 || this.m_session.getCompatGetTable() == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ372", "COMPAT_GETTABLE");
        }
        return this.m_session.getCompatGetTable();
    }

    @Override
    public String getCatalogName(int n) throws SQLException {
        return this.getColumnProperties(n).getCatalogName();
    }

    @Override
    public int getColumnType(int n) throws SQLException {
        return this.getColumnProperties(n).getColumnType();
    }

    public int getColumnBaseJDBCType(int n) throws SQLException {
        return this.getColumnProperties(n).getColumnBaseJDBCType();
    }

    @Override
    public String getColumnTypeName(int n) throws SQLException {
        return this.getColumnProperties(n).getColumnTypeName();
    }

    @Override
    public boolean isReadOnly(int n) throws SQLException {
        ColumnProperties columnProperties = this.getColumnProperties(n);
        if (this.shouldUseColumnProperties()) {
            return columnProperties.isReadOnly();
        }
        if (this.m_session.getCompatDBS() == 0 || this.m_session.getCompatIsReadOnly() == 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ372", "COMPAT_ISREADONLY");
        }
        return this.m_session.getCompatIsReadOnly() == 1;
    }

    @Override
    public boolean isWritable(int n) throws SQLException {
        ColumnProperties columnProperties = this.getColumnProperties(n);
        if (this.shouldUseColumnProperties()) {
            return columnProperties.isWritable();
        }
        if (this.m_session.getCompatDBS() == 0 || this.m_session.getCompatIsWritable() == 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ372", "COMPAT_ISWRITABLE");
        }
        return this.m_session.getCompatIsWritable() == 1;
    }

    @Override
    public boolean isDefinitelyWritable(int n) throws SQLException {
        ColumnProperties columnProperties = this.getColumnProperties(n);
        if (this.shouldUseColumnProperties()) {
            return columnProperties.isDefinitelyWritable();
        }
        if (this.m_session.getCompatDBS() == 0 || this.m_session.getCompatIsDefWrit() == 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ372", "COMPAT_ISDEFWRIT");
        }
        return this.m_session.getCompatIsDefWrit() == 1;
    }

    @Override
    public String getColumnClassName(int n) throws SQLException {
        Map map = this.m_session != null ? this.m_session.getTypeMap() : Collections.EMPTY_MAP;
        return this.getColumnProperties(n).getColumnClassName(map);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ733");
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }
}

