/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.teradata.model;

import com.dbeaver.db.teradata.model.TeradataDatasource;
import com.dbeaver.db.teradata.model.TeradataMacro;
import com.dbeaver.db.teradata.model.TeradataMap;
import com.dbeaver.db.teradata.model.TeradataObjectType;
import com.dbeaver.db.teradata.model.TeradataZone;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericObjectContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.ext.generic.model.GenericView;
import org.jkiss.dbeaver.ext.teradata.model.TeradataTrigger;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCStructureAssistant;
import org.jkiss.dbeaver.model.impl.struct.AbstractObjectReference;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.utils.ArrayUtils;

public class TeradataStructureAssistant
extends JDBCStructureAssistant<JDBCExecutionContext> {
    private TeradataDatasource dataSource;

    TeradataStructureAssistant(TeradataDatasource datasource) {
        this.dataSource = datasource;
    }

    protected JDBCDataSource getDataSource() {
        return this.dataSource;
    }

    @NotNull
    public DBSObjectType[] getSupportedObjectTypes() {
        return new DBSObjectType[]{RelationalObjectType.TYPE_TABLE, RelationalObjectType.TYPE_VIEW, RelationalObjectType.TYPE_PROCEDURE, RelationalObjectType.TYPE_TRIGGER, TeradataObjectType.M, TeradataObjectType.ZONE, TeradataObjectType.MAP};
    }

    @NotNull
    public DBSObjectType[] getAutoCompleteObjectTypes() {
        return new DBSObjectType[]{RelationalObjectType.TYPE_TABLE, RelationalObjectType.TYPE_VIEW, RelationalObjectType.TYPE_PROCEDURE};
    }

    @NotNull
    public DBSObjectType[] getHyperlinkObjectTypes() {
        return new DBSObjectType[]{RelationalObjectType.TYPE_TABLE, RelationalObjectType.TYPE_VIEW};
    }

    @NotNull
    public List<DBSObjectReference> findObjectsByMask(@NotNull DBRProgressMonitor monitor, @NotNull JDBCExecutionContext executionContext, @NotNull DBSStructureAssistant.ObjectsSearchParams params) throws DBException {
        ArrayList<DBSObjectReference> result = new ArrayList<DBSObjectReference>();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (JDBCSession session = executionContext.openSession(monitor, DBCExecutionPurpose.META, "Find objects by mask");){
                Object[] objectTypes = params.getObjectTypes();
                if (ArrayUtils.contains((Object[])objectTypes, (Object)RelationalObjectType.TYPE_TABLE) || ArrayUtils.contains((Object[])objectTypes, (Object)RelationalObjectType.TYPE_VIEW) || ArrayUtils.contains((Object[])objectTypes, (Object)RelationalObjectType.TYPE_PROCEDURE) || ArrayUtils.contains((Object[])objectTypes, (Object)RelationalObjectType.TYPE_TRIGGER) || ArrayUtils.contains((Object[])objectTypes, (Object)((Object)TeradataObjectType.M))) {
                    this.findObjectsByMask(executionContext, session, params, result);
                }
                if (ArrayUtils.contains((Object[])objectTypes, (Object)((Object)TeradataObjectType.ZONE))) {
                    this.findZonesByMask(session, params, result);
                }
                if (ArrayUtils.contains((Object[])objectTypes, (Object)((Object)TeradataObjectType.MAP))) {
                    this.findMapsByMask(session, params, result);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException ex) {
            throw new DBDatabaseException((Throwable)ex, (DBPDataSource)this.dataSource);
        }
        return result;
    }

    protected void findObjectsByMask(@NotNull JDBCExecutionContext executionContext, @NotNull JDBCSession session, @NotNull DBSObjectType objectType, @NotNull DBSStructureAssistant.ObjectsSearchParams params, @NotNull List<DBSObjectReference> references) throws SQLException {
        if (objectType == TeradataObjectType.MAP) {
            this.findMapsByMask(session, params, references);
        } else if (objectType == TeradataObjectType.ZONE) {
            this.findZonesByMask(session, params, references);
        } else {
            this.findObjectsByMask(executionContext, session, params, references);
        }
    }

    private void findObjectsByMask(@NotNull JDBCExecutionContext executionContext, @NotNull JDBCSession session, @NotNull DBSStructureAssistant.ObjectsSearchParams params, @NotNull List<DBSObjectReference> result) throws SQLException {
        List<DBSObjectType> objectTypesList = Arrays.asList(params.getObjectTypes());
        StringJoiner objectTypeClause = new StringJoiner(",");
        if (objectTypesList.contains(RelationalObjectType.TYPE_TABLE)) {
            this.addTypesToList(objectTypeClause, GenericTable.class);
        }
        if (objectTypesList.contains(RelationalObjectType.TYPE_VIEW)) {
            this.addTypesToList(objectTypeClause, GenericView.class);
        }
        if (objectTypesList.contains(RelationalObjectType.TYPE_PROCEDURE)) {
            this.addTypesToList(objectTypeClause, GenericProcedure.class);
        }
        if (objectTypesList.contains(RelationalObjectType.TYPE_TRIGGER)) {
            this.addTypesToList(objectTypeClause, TeradataTrigger.class);
        }
        if (objectTypesList.contains((Object)TeradataObjectType.M)) {
            this.addTypesToList(objectTypeClause, TeradataMacro.class);
        }
        boolean searchInComments = params.isSearchInComments();
        boolean searchInDefinitions = params.isSearchInDefinitions();
        boolean caseSensitive = params.isCaseSensitive();
        GenericSchema parentSchema = params.getParentObject() instanceof GenericSchema ? (GenericSchema)params.getParentObject() : (params.isGlobalSearch() ? (executionContext.getContextDefaults() != null ? (GenericSchema)executionContext.getContextDefaults().getDefaultSchema() : null) : null);
        String sql = "SELECT TOP " + (params.getMaxResults() - result.size()) + " DataBaseName, TableName, TableKind " + (searchInComments ? ",CommentString" : "") + (searchInDefinitions ? ",RequestText" : "") + " FROM DBC.TablesV\nWHERE TableKind IN (" + objectTypeClause.toString() + ")";
        sql = sql + " AND TableName LIKE ? " + (caseSensitive ? "(CASESPECIFIC)" : "");
        if (searchInComments) {
            sql = sql + " OR CommentString LIKE ? " + (caseSensitive ? "(CASESPECIFIC)" : "");
        }
        if (searchInDefinitions) {
            sql = sql + " OR RequestText LIKE ? " + (caseSensitive ? "(CASESPECIFIC)" : "");
        }
        if (parentSchema != null) {
            sql = sql + " AND DataBaseName = ?";
        }
        sql = sql + "\nORDER BY DataBaseName, TableName";
        DBRProgressMonitor monitor = session.getProgressMonitor();
        Throwable throwable = null;
        Object var14_15 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement(sql);){
            dbStat.setString(1, params.getMask());
            if (searchInComments) {
                dbStat.setString(2, params.getMask());
            }
            if (searchInDefinitions) {
                dbStat.setString(searchInComments ? 3 : 2, params.getMask());
            }
            if (parentSchema != null) {
                dbStat.setString(searchInComments && searchInDefinitions ? 4 : (searchInComments || searchInDefinitions ? 3 : 2), parentSchema.getName());
            }
            Throwable throwable2 = null;
            Object var17_20 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (!monitor.isCanceled() && dbResult.next()) {
                    GenericSchema schema;
                    String databaseName = dbResult.getString(1);
                    final String objectName = dbResult.getString(2);
                    String tableType = dbResult.getString(3);
                    String description = searchInComments ? dbResult.getString(4) : "";
                    GenericSchema genericSchema = schema = parentSchema != null ? parentSchema : this.dataSource.getSchema(databaseName);
                    if (schema == null) continue;
                    final TeradataObjectType objectType = TeradataObjectType.valueOf(tableType);
                    result.add((DBSObjectReference)new AbstractObjectReference<GenericSchema>(objectName, schema, description, ((Object)((Object)objectType)).getClass(), (DBSObjectType)objectType){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            DBSObject object = objectType.findObject(monitor, (GenericObjectContainer)schema, objectName);
                            if (object == null) {
                                throw new DBException(objectType.getTypeName() + " '" + objectName + "' not found in schema '" + schema.getName() + "'");
                            }
                            return object;
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void addTypesToList(@NotNull StringJoiner objectTypeClause, @NotNull Class<?> theClass) {
        List<TeradataObjectType> types = TeradataObjectType.getTypesForClass(theClass);
        types.forEach(e -> {
            StringJoiner stringJoiner2 = objectTypeClause.add("'" + e.name() + "'");
        });
    }

    private void findMapsByMask(@NotNull JDBCSession session, @NotNull DBSStructureAssistant.ObjectsSearchParams params, @NotNull List<DBSObjectReference> result) throws SQLException {
        boolean searchInComments = params.isSearchInComments();
        boolean caseSensitive = params.isCaseSensitive();
        String sql = "SELECT TOP " + (params.getMaxResults() - result.size()) + " MapName" + (searchInComments ? ", CommentString" : "") + "\nFROM DBC.MapsV\nWHERE MapName LIKE ? " + (caseSensitive ? "(CASESPECIFIC)" : "");
        if (searchInComments) {
            sql = sql + " OR CommentString LIKE ? " + (caseSensitive ? "(CASESPECIFIC)" : "");
        }
        sql = sql + "\nORDER BY MapName";
        DBRProgressMonitor monitor = session.getProgressMonitor();
        Throwable throwable = null;
        Object var9_10 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement(sql);){
            dbStat.setString(1, params.getMask());
            if (searchInComments) {
                dbStat.setString(2, params.getMask());
            }
            Throwable throwable2 = null;
            Object var12_15 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (!monitor.isCanceled() && dbResult.next()) {
                    final String objectName = dbResult.getString(1);
                    String description = searchInComments ? dbResult.getString(2) : "";
                    result.add((DBSObjectReference)new AbstractObjectReference<TeradataDatasource>(objectName, this.dataSource, description, TeradataMap.class, (DBSObjectType)TeradataObjectType.MAP){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            TeradataMap map = TeradataStructureAssistant.this.dataSource.getMap(monitor, objectName);
                            if (map == null) {
                                throw new DBException("Can't find map '" + this.getName() + "'");
                            }
                            return map;
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void findZonesByMask(@NotNull JDBCSession session, @NotNull DBSStructureAssistant.ObjectsSearchParams params, @NotNull List<DBSObjectReference> result) throws SQLException {
        boolean caseSensitive = params.isCaseSensitive();
        String sql = "SELECT TOP " + (params.getMaxResults() - result.size()) + " ZoneName FROM DBC.ZonesV\nWHERE ZoneName LIKE ? " + (caseSensitive ? "(CASESPECIFIC)" : "");
        sql = sql + "\nORDER BY ZoneName";
        DBRProgressMonitor monitor = session.getProgressMonitor();
        Throwable throwable = null;
        Object var8_9 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement(sql);){
            dbStat.setString(1, params.getMask());
            Throwable throwable2 = null;
            Object var11_14 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (!monitor.isCanceled() && dbResult.next()) {
                    final String objectName = dbResult.getString(1);
                    result.add((DBSObjectReference)new AbstractObjectReference<TeradataDatasource>(objectName, this.dataSource, null, TeradataZone.class, (DBSObjectType)TeradataObjectType.ZONE){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            TeradataZone zone = TeradataStructureAssistant.this.dataSource.getZone(monitor, objectName);
                            if (zone == null) {
                                throw new DBException("Can't find zone '" + this.getName() + "'");
                            }
                            return zone;
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public boolean supportsSearchInCommentsFor(@NotNull DBSObjectType objectType) {
        return objectType != TeradataObjectType.ZONE;
    }

    public boolean supportsSearchInDefinitionsFor(@NotNull DBSObjectType objectType) {
        return objectType != TeradataObjectType.ZONE && objectType != TeradataObjectType.MAP;
    }
}

