/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.teradata.model;

import com.dbeaver.db.teradata.model.TeradataDatabase;
import com.dbeaver.db.teradata.model.TeradataDatasource;
import com.dbeaver.db.teradata.model.TeradataRight;
import java.sql.ResultSet;
import java.util.Date;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.access.DBAObject;
import org.jkiss.dbeaver.model.access.DBAPrivilege;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class TeradataPrivilege
implements DBAPrivilege {
    private static final Log log = Log.getLog(TeradataPrivilege.class);
    private TeradataDatasource datasource;
    private DBAObject privilegeOwner;
    private TeradataDatabase database;
    private String tableName;
    private String columnName;
    private TeradataRight teradataRight;
    private String grantorName;
    private Date created;

    public TeradataPrivilege(@NotNull TeradataDatasource datasource, @NotNull DBAObject privilegeOwner, @NotNull String accessRightCode, @NotNull JDBCResultSet resultSet) {
        GenericSchema schema;
        this.datasource = datasource;
        this.privilegeOwner = privilegeOwner;
        String databaseName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"DatabaseName");
        if (CommonUtils.isNotEmpty((String)databaseName) && (schema = datasource.getSchema(databaseName)) instanceof TeradataDatabase) {
            TeradataDatabase ter;
            this.database = ter = (TeradataDatabase)schema;
        }
        this.tableName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"TableName");
        this.columnName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"ColumnName");
        this.teradataRight = (TeradataRight)CommonUtils.valueOf(TeradataRight.class, (String)accessRightCode);
        if (this.teradataRight == null) {
            log.debug((Object)("Can't find access right by code " + accessRightCode + ". Set Select access right"));
            this.teradataRight = TeradataRight.R;
        }
        this.grantorName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"GrantorName");
        this.created = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"CreateTimeStamp");
    }

    @Nullable
    public DBSObject getParentObject() {
        return this.privilegeOwner;
    }

    @Nullable
    public DBPDataSource getDataSource() {
        return this.datasource;
    }

    @Property(viewable=true, order=1)
    public TeradataDatabase getDatabase() {
        return this.database;
    }

    @Property(viewable=true, order=2)
    public String getTableName() {
        return this.tableName;
    }

    @Property(viewable=true, order=3)
    public String getColumnName() {
        return this.columnName;
    }

    @Property(viewable=true, order=4)
    public String getTeradataRight() {
        return this.teradataRight.getRightName();
    }

    @Property(viewable=true, order=5)
    public String getGrantorName() {
        return this.grantorName;
    }

    @Property(viewable=true, order=6)
    public Date getCreated() {
        return this.created;
    }

    @NotNull
    public String getName() {
        return this.privilegeOwner.getName() + "_" + this.database.getName() + "_" + this.tableName + "_" + this.teradataRight.getRightName();
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    public boolean isPersisted() {
        return true;
    }
}

