/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.teradata.model;

import com.dbeaver.db.teradata.model.TeradataDataTypeCache;
import com.dbeaver.db.teradata.model.TeradataDatabase;
import com.dbeaver.db.teradata.model.TeradataDatasource;
import com.dbeaver.db.teradata.model.TeradataTableColumn;
import com.dbeaver.db.teradata.model.TeradataValueType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.teradata.model.TeradataMetaModel;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPErrorAssistant;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.utils.CommonUtils;

public class TeradataMetaModelExt
extends TeradataMetaModel {
    private static final Log log = Log.getLog(TeradataMetaModelExt.class);

    @NotNull
    public GenericDataSource createDataSourceImpl(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        return new TeradataDatasource(monitor, container, (GenericMetaModel)this);
    }

    public TeradataDataTypeCache createDataTypeCache(@NotNull GenericStructContainer container) {
        return new TeradataDataTypeCache(container);
    }

    @Nullable
    public List<GenericSchema> loadSchemas(@NotNull JDBCSession session, @NotNull GenericDataSource dataSource, @Nullable GenericCatalog genericCatalog) throws DBException {
        TeradataDatasource tdds = (TeradataDatasource)dataSource;
        boolean showDatabasesHierarchically = tdds.showDatabasesHierarchically();
        String dbTable = tdds.showAllDatabases() ? "DatabasesV" : "DatabasesVX";
        String statement = "SELECT * FROM DBC." + dbTable + " ORDER BY DatabaseName";
        boolean catalogsRead = false;
        ArrayList<TeradataDatabase> resultList = new ArrayList<TeradataDatabase>();
        try {
            Throwable throwable = null;
            Iterator iterator = null;
            try (JDBCStatement dbStat = session.createStatement();){
                Throwable throwable2 = null;
                Object var14_18 = null;
                try (JDBCResultSet dbResult = dbStat.executeQuery(statement);){
                    while (dbResult != null && dbResult.next()) {
                        String name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DatabaseName");
                        if (CommonUtils.isEmpty((String)name)) continue;
                        String type = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DBKind");
                        boolean isUser = false;
                        if ("U".equalsIgnoreCase(type)) {
                            isUser = true;
                            if (CommonUtils.getBoolean((String)dataSource.getContainer().getConnectionConfiguration().getProviderProperty("hide-users@"), (boolean)false)) continue;
                        }
                        TeradataDatabase database = new TeradataDatabase(tdds, name, isUser, dbResult);
                        resultList.add(database);
                        catalogsRead = true;
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            if (dataSource.discoverErrorType((Throwable)e) == DBPErrorAssistant.ErrorType.CONNECTION_LOST) {
                throw new DBDatabaseException((Throwable)e, (DBPDataSource)dataSource);
            }
            catalogsRead = false;
        }
        if (!catalogsRead) {
            return super.loadSchemas(session, dataSource, null);
        }
        if (showDatabasesHierarchically) {
            for (TeradataDatabase database : resultList) {
                String databaseName = database.getName();
                String ownerName = database.getOwnerName();
                if ("DBC".equalsIgnoreCase(databaseName) || CommonUtils.isEmpty((String)ownerName) || databaseName.equals(ownerName) || "DBC".equalsIgnoreCase(ownerName)) {
                    tdds.addDatabaseToFirstLevel(database);
                    continue;
                }
                boolean found = false;
                for (TeradataDatabase catalog : resultList) {
                    if (!catalog.getName().equals(ownerName)) continue;
                    catalog.addChildDatabase(database);
                    database.setParentDatabase(catalog);
                    found = true;
                    break;
                }
                if (!found) {
                    log.warn((Object)("Cannot find owner database '" + ownerName + "'"));
                    continue;
                }
                if (!database.isUser() || !database.getOwnerName().equalsIgnoreCase(database.getCreatorName())) continue;
                tdds.addDatabaseToFirstLevel(database);
            }
        }
        return new ArrayList<GenericSchema>(resultList);
    }

    public JDBCStatement prepareUniqueConstraintsLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @Nullable GenericTableBase forParent) throws SQLException {
        JDBCPreparedStatement dbStat = session.prepareStatement("SELECT TableName AS TABLE_NAME, ColumnName AS COLUMN_NAME, CAST (ColumnPosition as SMALLINT) as KEY_SEQ, IndexName AS PK_NAME, IndexType\nFROM DBC.IndicesV\nWHERE IndexType IN ('K','U')\nAND DatabaseName = ?" + (forParent != null ? " AND TableName = ?" : "") + "\nORDER BY TableName, ColumnPosition");
        if (forParent != null) {
            dbStat.setString(1, forParent.getSchema().getName());
            dbStat.setString(2, forParent.getName());
        } else {
            dbStat.setString(1, owner.getName());
        }
        return dbStat;
    }

    public DBSEntityConstraintType getUniqueConstraintType(@NotNull JDBCResultSet dbResult) throws DBException, SQLException {
        String type = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"IndexType");
        if (type != null) {
            if ("U".equals(type)) {
                return DBSEntityConstraintType.UNIQUE_KEY;
            }
            return DBSEntityConstraintType.PRIMARY_KEY;
        }
        return super.getUniqueConstraintType(dbResult);
    }

    public boolean supportsUniqueKeys() {
        return true;
    }

    public JDBCStatement prepareTableColumnLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @Nullable GenericTableBase forTable) throws SQLException {
        StringBuilder ddl = new StringBuilder();
        ddl.append("select t.DatabaseName as TABLE_SCHEM, t.TableName as TABLE_NAME, ").append("c.ColumnName as COLUMN_NAME, c.ColumnType, (CASE WHEN c.COLUMNTYPE = 'UT' AND u.TypeKind = 'D' THEN ").append(TeradataMetaModelExt.caseDisplaySize("BaseTypes.COLUMNTYPE", "c.ColumnLength")).append(" ELSE ").append(TeradataMetaModelExt.caseDisplaySize("c.COLUMNTYPE", "c.COLUMNLENGTH")).append(" END) AS COLUMN_SIZE, ").append("cast ((CASE WHEN (c.COLUMNTYPE = 'N' OR c.COLUMNTYPE = 'UT' AND BaseTypes.COLUMNTYPE = 'N') AND ").append("c.DECIMALFRACTIONALDIGITS = -128 THEN 0 ELSE c.DECIMALFRACTIONALDIGITS END) as integer) as DECIMAL_DIGITS, ").append("c.Nullable, c.CommentString as REMARKS, c.DefaultValue as COLUMN_DEF, ").append("cast (c.ColumnLength as integer) as CHAR_OCTET_LENGTH, cast ((row_number () over (partition by TABLE_SCHEM, ").append("TABLE_NAME order by c.ColumnID)) as integer) as ORDINAL_POSITION, c.ColumnFormat, c.ColumnUDTName");
        if (owner.getDataSource().isServerVersionAtLeast(16, 0)) {
            ddl.append(", c.StorageFormat");
        }
        ddl.append(" from DBC.TablesV t join DBC.ColumnsV c on t.DatabaseName = c.DatabaseName and t.TableName = c.TableName ").append("left outer join DBC.UDTInfoV u on c.ColumnUDTName = u.TypeName left outer join DBC.ColumnsV BaseTypes on ").append("u.TypeKind = 'D' and 'SYSUDTLIB' = BaseTypes.DatabaseName (not casespecific) and u.TypeName (not casespecific) =").append("BaseTypes.TableName (not casespecific) where t.TableKind IN ('O', 'T', 'V') and c.DatabaseName (not casespecific) =?");
        if (forTable != null) {
            ddl.append(" and c.TableName (not casespecific) =?");
        }
        ddl.append(" order by TABLE_SCHEM, TABLE_NAME, ORDINAL_POSITION");
        JDBCPreparedStatement dbStat = session.prepareStatement(ddl.toString());
        if (forTable != null) {
            dbStat.setString(1, forTable.getSchema().getName());
            dbStat.setString(2, forTable.getName());
        } else {
            dbStat.setString(1, owner.getSchema().getName());
        }
        return dbStat;
    }

    public GenericTableColumn fetchTableColumn(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @NotNull GenericTableBase table, @NotNull JDBCResultSet dbResult) {
        String columnName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLUMN_NAME");
        String columnTypeCode = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ColumnType");
        TeradataValueType teradataValueType = (TeradataValueType)CommonUtils.valueOf(TeradataValueType.class, (String)columnTypeCode);
        int valueType = 0;
        String typeName = "";
        if (teradataValueType != null) {
            valueType = teradataValueType.getTypeId();
            String columnUDTName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ColumnUDTName");
            String storageFormat = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"StorageFormat");
            typeName = teradataValueType.getTypeName(columnUDTName, storageFormat);
        }
        long columnSize = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"COLUMN_SIZE");
        boolean isNotNull = !"Y".equals(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"Nullable"));
        Integer scale = null;
        try {
            scale = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"DECIMAL_DIGITS");
        }
        catch (Throwable e) {
            log.warn((Object)"Error getting column scale", e);
        }
        Integer precision = this.extractPrecisionOfNumericColumn(valueType, columnSize);
        String defaultValue = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLUMN_DEF");
        String remarks = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"REMARKS");
        long charLength = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"CHAR_OCTET_LENGTH");
        int ordinalPos = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"ORDINAL_POSITION");
        String formatValue = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ColumnFormat");
        return new TeradataTableColumn(table, columnName, typeName, valueType, valueType, ordinalPos, columnSize, charLength, scale, precision, 10, isNotNull, remarks, defaultValue, false, false, formatValue);
    }

    private static String caseDisplaySize(String typeColumn, String lengthColumn) {
        return " CAST ((CASE WHEN " + typeColumn + " = 'AT' THEN 15 WHEN (" + typeColumn + " = 'CF' OR " + typeColumn + " = 'CO' OR " + typeColumn + " = 'CV' OR " + typeColumn + " = 'GF' OR " + typeColumn + " = 'GV' OR " + typeColumn + " = 'JN' OR " + typeColumn + " = 'XM') AND (c.CHARTYPE = 2 OR c.CHARTYPE = 4) THEN " + lengthColumn + " / 2 WHEN " + typeColumn + " = 'D' THEN c.DECIMALTOTALDIGITS WHEN " + typeColumn + " = 'DA' THEN 10 WHEN " + typeColumn + " = 'DH' THEN 4 + c.DECIMALTOTALDIGITS WHEN " + typeColumn + " = 'DM' THEN 7 + c.DECIMALTOTALDIGITS WHEN " + typeColumn + " = 'DS' THEN 17 + c.DECIMALTOTALDIGITS WHEN " + typeColumn + " = 'DY' THEN 1 + c.DECIMALTOTALDIGITS WHEN " + typeColumn + " = 'F' THEN 15 WHEN " + typeColumn + " = 'HM' THEN 4 + c.DECIMALTOTALDIGITS WHEN " + typeColumn + " = 'HR' THEN 1 + c.DECIMALTOTALDIGITS WHEN " + typeColumn + " = 'HS' THEN 14 + c.DECIMALTOTALDIGITS WHEN " + typeColumn + " = 'I1' THEN 3 WHEN " + typeColumn + " = 'I2' THEN 5 WHEN " + typeColumn + " = 'I'  THEN 10 WHEN " + typeColumn + " = 'I8' THEN 19 WHEN " + typeColumn + " = 'MI' THEN 1 + c.DECIMALTOTALDIGITS WHEN " + typeColumn + " = 'MO' THEN 1 + c.DECIMALTOTALDIGITS WHEN " + typeColumn + " = 'MS' THEN 11 + c.DECIMALTOTALDIGITS WHEN " + typeColumn + " = 'N'  THEN (CASE WHEN c.DECIMALTOTALDIGITS = -128 THEN 40 ELSE c.DECIMALTOTALDIGITS END) WHEN " + typeColumn + " = 'PD' THEN 28 WHEN " + typeColumn + " = 'PM' THEN 72 WHEN " + typeColumn + " = 'PS' THEN 60 WHEN " + typeColumn + " = 'PT' THEN 38 WHEN " + typeColumn + " = 'PZ' THEN 50 WHEN " + typeColumn + " = 'SC' THEN 8 + c.DECIMALTOTALDIGITS WHEN " + typeColumn + " = 'SZ' THEN 32 WHEN " + typeColumn + " = 'TS' THEN 26 WHEN " + typeColumn + " = 'TZ' THEN 21 WHEN " + typeColumn + " = 'YM' THEN 4 + c.DECIMALTOTALDIGITS WHEN " + typeColumn + " = 'YR' THEN 1 + c.DECIMALTOTALDIGITS ELSE " + lengthColumn + " END) AS INTEGER)";
    }
}

