/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.teradata.data;

import com.dbeaver.db.teradata.model.TeradataDateFormat;
import com.dbeaver.db.teradata.model.TeradataTableColumn;
import java.util.Date;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDFormatSettings;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCDateTimeValueHandler;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class TeradataDateTimeValueHandler
extends JDBCDateTimeValueHandler {
    public TeradataDateTimeValueHandler(DBDFormatSettings formatSettings) {
        super(formatSettings);
    }

    @NotNull
    public String getValueDisplayString(@NotNull DBSTypedObject column, Object value, @NotNull DBDDisplayFormat format) {
        TeradataTableColumn teradataTableColumn;
        TeradataDateFormat dateFormat;
        if (value instanceof Date && (format == DBDDisplayFormat.UI || format == DBDDisplayFormat.NATIVE) && column instanceof TeradataTableColumn && (dateFormat = (teradataTableColumn = (TeradataTableColumn)column).getDateFormat()) != null) {
            return dateFormat.format(value);
        }
        return super.getValueDisplayString(column, value, format);
    }

    @NotNull
    protected String getFormatterId(DBSTypedObject column) {
        switch (column.getTypeName()) {
            case "TIME WITH TIME ZONE": {
                return "timetz";
            }
            case "TIMESTAMP WITH TIME ZONE": {
                return "timestamptz";
            }
        }
        return super.getFormatterId(column);
    }
}

