/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.base;

import com.dbeaver.jdbc.base.ValueReader;
import java.sql.SQLType;
import java.util.Objects;

public final class ColumnInfo<TYPE> {
    private final String catalogName;
    private final String schemaName;
    private final String tableName;
    private final String columnName;
    private final String columnLabel;
    private final int type;
    private String typeName;
    private int precision;
    private final ValueReader<TYPE> reader;
    private final int nullable;

    public ColumnInfo(String catalogName, String schemaName, String tableName, String columnName, String columnLabel, int type, String typeName, int precision, ValueReader<TYPE> reader, int nullable) {
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.columnName = columnName;
        this.columnLabel = columnLabel;
        this.type = type;
        this.typeName = typeName;
        this.precision = precision;
        this.reader = reader;
        this.nullable = nullable;
    }

    public ColumnInfo(String columnName, String columnLabel, int type, ValueReader<TYPE> reader) {
        this(null, null, null, columnName, columnLabel, type, null, -1, reader, 2);
    }

    public ColumnInfo(String tableName, String columnName, String columnLabel, int type, String typeName, ValueReader<TYPE> reader) {
        this(null, null, tableName, columnName, columnLabel, type, typeName, -1, reader, 2);
    }

    public ColumnInfo(String columnName, SQLType type, ValueReader<TYPE> reader) {
        this(null, null, columnName, columnName, type, reader);
    }

    public ColumnInfo(String schemaName, String tableName, String columnName, String columnLabel, SQLType type) {
        this(schemaName, tableName, columnName, columnLabel, type, ValueReader.DEFAULT);
    }

    public ColumnInfo(String schemaName, String tableName, String columnName, String columnLabel, SQLType type, int precision) {
        this(schemaName, tableName, columnName, columnLabel, type, ValueReader.DEFAULT);
        this.setPrecision(precision);
    }

    public ColumnInfo(String schemaName, String tableName, String columnName, String columnLabel, SQLType type, ValueReader<TYPE> reader) {
        this(null, schemaName, tableName, columnName, columnLabel, type.getVendorTypeNumber(), type.getName(), -1, reader, 2);
    }

    public String toString() {
        return this.columnName;
    }

    public String catalogName() {
        return this.catalogName;
    }

    public String schemaName() {
        return this.schemaName;
    }

    public String tableName() {
        return this.tableName;
    }

    public String columnName() {
        return this.columnName;
    }

    public String columnLabel() {
        return this.columnLabel;
    }

    public int type() {
        return this.type;
    }

    public String typeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public int precision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public ValueReader<TYPE> reader() {
        return this.reader;
    }

    public int nullable() {
        return this.nullable;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ColumnInfo that = (ColumnInfo)obj;
        return Objects.equals(this.catalogName, that.catalogName) && Objects.equals(this.schemaName, that.schemaName) && Objects.equals(this.tableName, that.tableName) && Objects.equals(this.columnName, that.columnName) && Objects.equals(this.columnLabel, that.columnLabel) && this.type == that.type && Objects.equals(this.typeName, that.typeName) && this.precision == that.precision && Objects.equals(this.reader, that.reader) && this.nullable == that.nullable;
    }

    public int hashCode() {
        return Objects.hash(this.catalogName, this.schemaName, this.tableName, this.columnName, this.columnLabel, this.type, this.typeName, this.precision, this.reader, this.nullable);
    }
}

