/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.base;

import com.dbeaver.jdbc.FileJdbcDriverLicenseProvider;
import com.dbeaver.jdbc.JdbcDriverLicenseProvider;
import com.dbeaver.jdbc.JdbcDriverLicensed;
import com.dbeaver.jdbc.base.BaseJdbcUtils;
import com.dbeaver.jdbc.model.AbstractJdbcDriver;
import com.dbeaver.lm.api.LMException;
import com.dbeaver.lm.api.LMLicense;
import com.dbeaver.lm.api.LMLicenseManager;
import com.dbeaver.lm.api.LMProduct;
import com.dbeaver.lm.api.LMProductType;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.jkiss.api.ObjectWithContextParameters;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;

public abstract class BaseJdbcDriver
extends AbstractJdbcDriver
implements JdbcDriverLicensed,
ObjectWithContextParameters {
    public static final String LICENSE_PATH_PROPERTY_NAME = "licensePath";
    private final int defaultVersionMajor;
    private final int defaultVersionMinor;
    private final Map<String, Object> contextParameters = new HashMap<String, Object>();

    public BaseJdbcDriver(String driverUrlPrefix, int defaultVersionMajor, int defaultVersionMinor) {
        super(driverUrlPrefix);
        this.defaultVersionMajor = defaultVersionMajor;
        this.defaultVersionMinor = defaultVersionMinor;
    }

    @NotNull
    public Map<String, Object> getObjectContextParameters() {
        return new HashMap<String, Object>(this.contextParameters);
    }

    @Nullable
    public Object getObjectContextParameter(@NotNull String name) {
        return this.contextParameters.get(name);
    }

    public void setObjectContextParameter(@NotNull String name, @Nullable Object value) {
        this.contextParameters.put(name, value);
    }

    @Override
    public boolean isLicenseRequired() {
        return true;
    }

    @Override
    public boolean isLicenseApplicable(LMLicense license) {
        return !license.isExpired();
    }

    @Override
    public LMProduct getLicensedProduct() {
        return new LMProduct("dbeaver-ee", "DB", "DBeaver JDBC Driver", "DBeaver JDBC Driver", this.defaultVersionMajor + "." + this.defaultVersionMinor, LMProductType.DESKTOP, new Date(), new String[]{"dbeaver-ue"});
    }

    public final Connection connect(String url, Properties info) throws SQLException {
        this.verifyLicense(info);
        if (!this.acceptsURL(url)) {
            return null;
        }
        return this.connectImpl(url, info);
    }

    private void verifyLicense(Properties info) throws SQLException {
        String licensePath = info.getProperty(LICENSE_PATH_PROPERTY_NAME, "");
        if (!licensePath.isBlank()) {
            LMLicenseManager.addLicenseSearchPath((Path)Path.of(licensePath, new String[0]));
        }
        FileJdbcDriverLicenseProvider.activate();
        try {
            JdbcDriverLicenseProvider licenseProvider = JdbcDriverLicenseProvider.getInstance();
            if (licenseProvider == null) {
                throw new LMException("Driver license provider not instantiated");
            }
            LMLicense license = licenseProvider.locateDriverLicense(this);
            if (license != null && this.isLicenseApplicable(license)) {
                return;
            }
        }
        catch (LMException e) {
            this.getParentLogger().log(Level.SEVERE, "Cannot locate license", e);
        }
        throw new SQLException("Cannot find applicable license for JDBC driver '" + this.getDriverIdentifier() + "'");
    }

    protected abstract Connection connectImpl(String var1, Properties var2) throws SQLException;

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        return new DriverPropertyInfo[0];
    }

    public boolean jdbcCompliant() {
        return false;
    }

    public int getMajorVersion() {
        if (BaseJdbcUtils.isOsgiAvailable()) {
            try {
                return this.getOwnBundle().getVersion().getMajor();
            }
            catch (Throwable throwable) {}
        }
        return this.defaultVersionMajor;
    }

    public int getMinorVersion() {
        if (BaseJdbcUtils.isOsgiAvailable()) {
            try {
                return this.getOwnBundle().getVersion().getMinor();
            }
            catch (Throwable throwable) {}
        }
        return this.defaultVersionMinor;
    }

    public int getMicroVersion() {
        if (BaseJdbcUtils.isOsgiAvailable()) {
            try {
                return this.getOwnBundle().getVersion().getMicro();
            }
            catch (Throwable throwable) {}
        }
        return 0;
    }

    @NotNull
    private Bundle getOwnBundle() {
        ClassLoader classLoader;
        if (BaseJdbcUtils.isOsgiAvailable() && (classLoader = this.getClass().getClassLoader()) instanceof BundleReference) {
            return ((BundleReference)classLoader).getBundle();
        }
        throw new IllegalStateException("Not in OSGI context");
    }
}

