/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.win32.com;

import com.dbeaver.model.win32.com.COMUtils;
import com.dbeaver.model.win32.com.ITaskDefinition;
import com.dbeaver.model.win32.com.ITaskFolder;
import com.sun.jna.platform.win32.COM.COMLateBindingObject;
import com.sun.jna.platform.win32.COM.IDispatch;
import com.sun.jna.platform.win32.Variant;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public class ITaskService
extends COMLateBindingObject {
    public ITaskService() {
        super("Schedule.Service", true);
    }

    public void connect(@Nullable String serverName, @Nullable String user, @Nullable String domain, @Nullable String password) {
        Variant.VARIANT serverNameVariant = COMUtils.makeVariant(serverName);
        Variant.VARIANT userVariant = COMUtils.makeVariant(user);
        Variant.VARIANT domainVariant = COMUtils.makeVariant(domain);
        Variant.VARIANT passwordVariant = COMUtils.makeVariant(password);
        try {
            this.invokeNoReply("Connect", serverNameVariant, userVariant, domainVariant, passwordVariant);
        }
        finally {
            COMUtils.freeVariant(serverNameVariant);
            COMUtils.freeVariant(userVariant);
            COMUtils.freeVariant(domainVariant);
            COMUtils.freeVariant(passwordVariant);
        }
    }

    @NotNull
    public ITaskDefinition newTask() {
        return new ITaskDefinition((IDispatch)this.invoke("NewTask", COMUtils.makeVariant(0L)).getValue());
    }

    @NotNull
    public ITaskFolder getFolder(@NotNull String path) {
        Variant.VARIANT userVariant = COMUtils.makeVariant(path);
        try {
            ITaskFolder iTaskFolder = new ITaskFolder((IDispatch)this.invoke("GetFolder", userVariant).getValue());
            return iTaskFolder;
        }
        finally {
            COMUtils.freeVariant(userVariant);
        }
    }
}

