/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.win32.com;

import com.dbeaver.model.win32.com.IBitsetEnumValue;
import com.dbeaver.model.win32.com.IEnumValue;
import com.sun.jna.Native;
import com.sun.jna.platform.win32.COM.Dispatch;
import com.sun.jna.platform.win32.COM.IDispatch;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.OaIdl;
import com.sun.jna.platform.win32.OleAuto;
import com.sun.jna.platform.win32.Variant;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.PointerByReference;
import com.sun.jna.win32.W32APIOptions;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.EnumSet;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.registry.timezone.TimezoneRegistry;

public class COMUtils {
    public static final String IID_IExecAction = "4c3d624d-fd6b-49a3-b9b7-09cb3cd3f047";
    public static final String IID_ITimeTrigger = "b45747e0-eba7-4276-9f29-85c5bb300006";
    public static final String IID_IDailyTrigger = "126c5cd8-b288-41d5-8dbf-e491446adc5c";
    public static final String IID_IWeeklyTrigger = "5038fc98-82ff-436d-8728-a512a57c9dc1";
    public static final String IID_IMonthlyTrigger = "97c45ef1-6b02-4a1a-9c0e-1ebfba1500ac";
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss[XXX]");

    private COMUtils() {
    }

    @NotNull
    public static IDispatch query(@NotNull IDispatch dispatch, @NotNull String interfaceId) {
        PointerByReference result = new PointerByReference();
        com.sun.jna.platform.win32.COM.COMUtils.checkRC((WinNT.HRESULT)dispatch.QueryInterface(new Guid.REFIID(new Guid.IID(interfaceId)), result));
        return new Dispatch(result.getValue());
    }

    @NotNull
    public static LocalDateTime getLocalDateTime(@NotNull String text) {
        TemporalAccessor accessor = DATE_TIME_FORMATTER.parseBest(text, ZonedDateTime::from, LocalDateTime::from);
        if (accessor instanceof ZonedDateTime) {
            return ((ZonedDateTime)accessor).toLocalDateTime();
        }
        return (LocalDateTime)accessor;
    }

    @Nullable
    public static LocalDateTime getLocalDateTime(@NotNull OaIdl.DATE date) {
        if (date.date == 0.0) {
            return null;
        }
        WinBase.SYSTEMTIME result = new WinBase.SYSTEMTIME();
        if (OleAutoExt.INSTANCE.VariantTimeToSystemTime(date.date, result) == 0) {
            return null;
        }
        return LocalDateTime.of((int)result.wYear, result.wMonth, (int)result.wDay, (int)result.wHour, (int)result.wMinute, (int)result.wSecond);
    }

    @NotNull
    public static <E extends Enum<E>> E getEnum(@NotNull Class<E> cls, int value) {
        Enum[] enumArray = (Enum[])cls.getEnumConstants();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enum constant = enumArray[n2];
            if (((IEnumValue)((Object)constant)).value() == value) {
                return (E)constant;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Cannot convert value " + value + " into enum of type " + cls.getName());
    }

    @NotNull
    public static <E extends Enum<E>> EnumSet<E> getEnumSet(@NotNull Class<E> cls, int mask) {
        EnumSet<Enum> set = EnumSet.noneOf(cls);
        Enum[] enumArray = (Enum[])cls.getEnumConstants();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enum constant = enumArray[n2];
            if ((((IBitsetEnumValue)((Object)constant)).value() & mask) > 0) {
                set.add(constant);
            }
            ++n2;
        }
        return set;
    }

    @NotNull
    public static Variant.VARIANT makeVariant(@NotNull LocalDateTime localDateTime) {
        return COMUtils.makeVariant(localDateTime.atZone(ZoneId.of(TimezoneRegistry.getUserDefaultTimezone())).format(DATE_TIME_FORMATTER));
    }

    @NotNull
    public static Variant.VARIANT makeVariant(@NotNull Duration duration) {
        return COMUtils.makeVariant(duration.toString());
    }

    @NotNull
    public static <E extends Enum<E>> Variant.VARIANT makeVariant(@NotNull EnumSet<E> value) {
        int mask = 0;
        for (Enum constant : value) {
            mask |= ((IBitsetEnumValue)((Object)constant)).value();
        }
        return COMUtils.makeVariant(mask);
    }

    @NotNull
    public static <E extends Enum<E>> Variant.VARIANT makeVariant(@NotNull E value) {
        return COMUtils.makeVariant(((IEnumValue)((Object)value)).value());
    }

    @NotNull
    public static Variant.VARIANT makeVariant(int value) {
        return new Variant.VARIANT(value);
    }

    @NotNull
    public static Variant.VARIANT makeVariant(long value) {
        return new Variant.VARIANT(value);
    }

    @NotNull
    public static Variant.VARIANT makeVariant(@Nullable String value) {
        return value == null ? Variant.VARIANT.VARIANT_MISSING : new Variant.VARIANT(value);
    }

    public static void freeVariant(@NotNull Variant.VARIANT variant) {
        OleAuto.INSTANCE.VariantClear(variant);
    }

    private static interface OleAutoExt
    extends OleAuto {
        public static final OleAutoExt INSTANCE = (OleAutoExt)Native.loadLibrary((String)"OleAut32", OleAutoExt.class, (Map)W32APIOptions.DEFAULT_OPTIONS);

        public int VariantTimeToSystemTime(double var1, WinBase.SYSTEMTIME var3);
    }
}

