/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.sched.system.cron;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class CrontabEditor {
    private static final String TASKS_BLOCK_START = "##### DBEAVER CRON JOBS DO NOT MODIFY BY HAND";
    private static final String TASKS_BLOCK_END = "##### END OF DBEAVER CRON JOBS";
    private static final String ARG_RUN_TASK = "-runTask";
    private static final String ARG_NO_SPLASH = "-nosplash";
    private final String leading;
    private final String trailing;
    private final Map<String, String> tasks;

    private CrontabEditor(@NotNull String leading, @NotNull String trailing, @NotNull Map<String, String> tasks) {
        this.leading = leading;
        this.trailing = trailing;
        this.tasks = tasks;
    }

    @NotNull
    public static CrontabEditor loadCrontab() throws IOException {
        return CrontabEditor.loadCrontab(CrontabEditor.readCrontab());
    }

    @NotNull
    public static CrontabEditor loadCrontab(@NotNull String crontab) {
        StringJoiner leading = new StringJoiner("\n");
        StringJoiner trailing = new StringJoiner("\n");
        HashMap<String, String> tasks = new HashMap<String, String>();
        ScannerState state = ScannerState.BEFORE_TASKS;
        String[] stringArray = crontab.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.equals(TASKS_BLOCK_START)) {
                state = ScannerState.INSIDE_TASKS;
            } else if (line.equals(TASKS_BLOCK_END)) {
                state = ScannerState.AFTER_TASKS;
            } else {
                switch (state) {
                    case BEFORE_TASKS: {
                        leading.add(line);
                        break;
                    }
                    case INSIDE_TASKS: {
                        int beginning = line.indexOf(ARG_RUN_TASK);
                        int ending = line.indexOf(ARG_NO_SPLASH);
                        if (beginning >= 0 && ending >= 0) {
                            String data = line.substring(beginning + ARG_RUN_TASK.length(), ending).trim();
                            tasks.put(CommonUtils.unescapeBourneShellString((String)data), line);
                            break;
                        }
                        state = ScannerState.AFTER_TASKS;
                        trailing.add(line);
                        break;
                    }
                    case AFTER_TASKS: {
                        trailing.add(line);
                    }
                }
            }
            ++n2;
        }
        return new CrontabEditor(leading.toString(), trailing.toString(), tasks);
    }

    @NotNull
    public String getLeading() {
        return this.leading;
    }

    @NotNull
    public String getTrailing() {
        return this.trailing;
    }

    @NotNull
    public Map<String, String> getTasks() {
        return Collections.unmodifiableMap(this.tasks);
    }

    @Nullable
    public String get(@NotNull String runTaskParameter) {
        return this.tasks.get(runTaskParameter);
    }

    public void upsert(@NotNull String runTaskParameter, @NotNull String entry) {
        this.tasks.put(runTaskParameter, entry);
    }

    public void remove(@NotNull String runTaskParameter) {
        this.tasks.remove(runTaskParameter);
    }

    public void flush() throws IOException {
        Process process = Runtime.getRuntime().exec(new String[]{"crontab", "-"});
        Throwable throwable = null;
        Object var3_5 = null;
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(process.getOutputStream()));){
            for (String line : this.makeCrontab()) {
                writer.write(line);
                writer.write(10);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        int code = CrontabEditor.waitFor(process);
        if (code != 0) {
            throw new IOException("crontab process ended with code " + code + ": " + CrontabEditor.readFully(process.getErrorStream()));
        }
    }

    @NotNull
    public static String readCrontab() throws IOException {
        Process process = Runtime.getRuntime().exec(new String[]{"crontab", "-l"});
        int code = CrontabEditor.waitFor(process);
        if (code != 0) {
            String stderr = CrontabEditor.readFully(process.getErrorStream());
            if (stderr.contains("no crontab for")) {
                return "";
            }
            throw new IOException("crontab process ended with code " + code + ": " + stderr);
        }
        return CrontabEditor.readFully(process.getInputStream());
    }

    @NotNull
    private List<String> makeCrontab() {
        ArrayList<String> contents = new ArrayList<String>();
        if (!this.leading.isEmpty()) {
            contents.add(this.leading);
        }
        if (!this.tasks.isEmpty()) {
            contents.add(TASKS_BLOCK_START);
            contents.addAll(this.tasks.values());
            contents.add(TASKS_BLOCK_END);
        }
        if (!this.trailing.isEmpty()) {
            contents.add(this.trailing);
        }
        return contents;
    }

    private static int waitFor(@NotNull Process process) throws IOException {
        try {
            return process.waitFor();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    @NotNull
    private static String readFully(@NotNull InputStream is) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringWriter writer = new StringWriter();
        IOUtils.copyText((Reader)reader, (Writer)writer);
        return ((Object)writer).toString();
    }

    private static enum ScannerState {
        BEFORE_TASKS,
        INSIDE_TASKS,
        AFTER_TASKS;

    }
}

