/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.sched.system.cron;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import java.time.Month;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Optional;
import java.util.TimeZone;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.task.DBTTaskScheduleConfiguration;
import org.jkiss.dbeaver.registry.timezone.TimezoneRegistry;
import org.jkiss.utils.CommonUtils;

public final class ConfigurationConverter {
    private static final Log log = Log.getLog(ConfigurationConverter.class);

    private ConfigurationConverter() {
    }

    static String nextRunInfo(String cronExpression) {
        CronParser cronParser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.UNIX));
        Cron cron = cronParser.parse(cronExpression);
        ExecutionTime executionTime = ExecutionTime.forCron((Cron)cron);
        Optional nextExec = executionTime.nextExecution(ZonedDateTime.now());
        return nextExec.map(ZonedDateTime::toString).orElse("never");
    }

    @Nullable
    public static DBTTaskScheduleConfiguration toDBTTaskScheduleConfiguration(String cronExpression) {
        String[] months;
        int n;
        int n2;
        String[] stringArray;
        String[] expr = cronExpression.trim().split(" ");
        if (expr.length != 5) {
            return null;
        }
        DBTTaskScheduleConfiguration conf = new DBTTaskScheduleConfiguration();
        if (expr[1].equals("*") && expr[2].equals("*") && expr[3].equals("*") && expr[4].equals("*")) {
            conf.frequency = DBTTaskScheduleConfiguration.Frequency.MINUTELY;
            conf.recurrence = CommonUtils.toInt((Object)expr[0].substring(2));
            return conf;
        }
        if (expr[1].length() > 2 && expr[2].equals("*") && expr[3].equals("*") && expr[4].equals("*")) {
            conf.frequency = DBTTaskScheduleConfiguration.Frequency.HOURLY;
            conf.recurrence = CommonUtils.toInt((Object)expr[1].substring(2));
            conf.executionMinute = CommonUtils.toInt((Object)expr[0]);
            return conf;
        }
        conf.startTime = ConfigurationConverter.getDateWithMinuteAndHour(expr[0], expr[1]);
        if (!expr[4].equals("*")) {
            String[] weekdays;
            conf.frequency = DBTTaskScheduleConfiguration.Frequency.WEEKLY;
            conf.days = new ArrayList(7);
            String[] stringArray2 = weekdays = expr[4].split(",");
            int n3 = weekdays.length;
            int n4 = 0;
            while (n4 < n3) {
                String weekday = stringArray2[n4];
                conf.days.add(ConfigurationConverter.toDBTTaskScheduleConfigurationWeekday(CommonUtils.toInt((Object)weekday)));
                ++n4;
            }
            return conf;
        }
        if (expr[3].equals("*")) {
            conf.frequency = DBTTaskScheduleConfiguration.Frequency.DAILY;
            conf.recurrence = 1;
            return conf;
        }
        conf.frequency = DBTTaskScheduleConfiguration.Frequency.MONTHLY;
        conf.days = new ArrayList();
        conf.months = new ArrayList();
        if (expr[2].equals("*")) {
            conf.days.add((short)33);
        } else {
            String[] days;
            stringArray = days = expr[2].split(",");
            n2 = days.length;
            n = 0;
            while (n < n2) {
                String day = stringArray[n];
                conf.days.add(Short.parseShort(day));
                ++n;
            }
        }
        stringArray = months = expr[3].split(",");
        n2 = months.length;
        n = 0;
        while (n < n2) {
            String month = stringArray[n];
            conf.months.add((short)(Short.parseShort(month) - 1));
            ++n;
        }
        return conf;
    }

    private static Date getDateWithMinuteAndHour(String minuteString, String hourString) {
        Calendar calendar = GregorianCalendar.getInstance(TimeZone.getTimeZone(TimezoneRegistry.getUserDefaultTimezone()));
        calendar.set(11, CommonUtils.toInt((Object)hourString));
        calendar.set(12, CommonUtils.toInt((Object)minuteString));
        return calendar.getTime();
    }

    public static String toCronExpression(DBTTaskScheduleConfiguration scheduleConfiguration) throws DBException {
        switch (scheduleConfiguration.frequency) {
            case DAILY: {
                return ConfigurationConverter.getCronExpressionForDailyTask(scheduleConfiguration);
            }
            case HOURLY: {
                return ConfigurationConverter.getCronExpressionForHourlyTask(scheduleConfiguration.recurrence, scheduleConfiguration.executionMinute);
            }
            case WEEKLY: {
                return ConfigurationConverter.getCronExpressionForWeeklyTask(scheduleConfiguration);
            }
            case MONTHLY: {
                return ConfigurationConverter.getCronExpressionForMonthlyTask(scheduleConfiguration);
            }
            case MINUTELY: {
                return ConfigurationConverter.getCronExpressionForMinutelyTask(scheduleConfiguration.recurrence);
            }
        }
        log.debug((Object)("error converting to cron expr, bad frequency " + scheduleConfiguration.frequency.name()));
        return null;
    }

    private static String getCronExpressionForMinutelyTask(int recurrence) throws DBException {
        if (recurrence < 1 || 60 % recurrence != 0) {
            throw new DBException("Unsupported recurrence for minutely task. Recurrence must be a divisor of 60");
        }
        return "*/" + recurrence + " * * * *";
    }

    private static String getCronExpressionForHourlyTask(int recurrence, int executionMinute) throws DBException {
        if (recurrence < 1 || 24 % recurrence != 0) {
            throw new DBException("Unsupported recurrence for hourly task. Recurrence must be a divisor of 24");
        }
        if (executionMinute < 0 || executionMinute > 59) {
            throw new DBException("Unsupported execution minute.");
        }
        return executionMinute + " */" + recurrence + " * * *";
    }

    private static String getCronExpressionForDailyTask(DBTTaskScheduleConfiguration cfg) {
        return ConfigurationConverter.getMinuteHourPart(cfg) + " * * *";
    }

    private static String getCronExpressionForMonthlyTask(DBTTaskScheduleConfiguration cfg) throws DBException {
        int i;
        List days = cfg.days;
        List months = cfg.months;
        ConfigurationConverter.checkDaysAndMonthsCombinationInvalid(days, months);
        StringBuilder stringBuilder = new StringBuilder(ConfigurationConverter.getMinuteHourPart(cfg) + " ");
        if (days.contains((short)33)) {
            stringBuilder.append('*');
        } else {
            stringBuilder.append(days.get(0));
            i = 1;
            while (i < days.size()) {
                short day = (Short)days.get(i);
                if (day != 32) {
                    stringBuilder.append(',').append(days.get(i));
                }
                ++i;
            }
        }
        stringBuilder.append(' ').append((Short)months.get(0) + 1);
        i = 1;
        while (i < months.size()) {
            stringBuilder.append(',').append((Short)months.get(i) + 1);
            ++i;
        }
        stringBuilder.append(" *");
        return stringBuilder.toString();
    }

    public static String getQuartzCronExpressionForMonthlyTask(DBTTaskScheduleConfiguration cfg) throws DBException {
        int i;
        List days = cfg.days;
        List months = cfg.months;
        ConfigurationConverter.checkDaysAndMonthsCombinationInvalid(days, months);
        StringBuilder stringBuilder = new StringBuilder("0 " + ConfigurationConverter.getMinuteHourPart(cfg) + " ");
        if (days.contains((short)33)) {
            stringBuilder.append('?');
        } else {
            stringBuilder.append(days.get(0));
            i = 1;
            while (i < days.size()) {
                short day = (Short)days.get(i);
                if (day != 32) {
                    stringBuilder.append(',').append(day);
                }
                ++i;
            }
        }
        stringBuilder.append(' ').append((Short)months.get(0) + 1);
        i = 1;
        while (i < months.size()) {
            stringBuilder.append(',').append((Short)months.get(i) + 1);
            ++i;
        }
        if (days.contains((short)33)) {
            stringBuilder.append(" *");
        } else {
            stringBuilder.append(" ?");
        }
        return stringBuilder.toString();
    }

    @Nullable
    public static DBTTaskScheduleConfiguration getMonthlyConfigurationFromQuartzCronExpression(String cronExpression) {
        String[] months;
        int n;
        int n2;
        String[] stringArray;
        String[] expr = cronExpression.trim().split(" ");
        if (expr.length != 6) {
            return null;
        }
        DBTTaskScheduleConfiguration conf = new DBTTaskScheduleConfiguration();
        conf.frequency = DBTTaskScheduleConfiguration.Frequency.MONTHLY;
        conf.startTime = ConfigurationConverter.getDateWithMinuteAndHour(expr[1], expr[2]);
        conf.days = new ArrayList();
        conf.months = new ArrayList();
        if (expr[3].equals("?")) {
            conf.days.add((short)33);
        } else {
            String[] days;
            stringArray = days = expr[3].split(",");
            n2 = days.length;
            n = 0;
            while (n < n2) {
                String day = stringArray[n];
                conf.days.add(Short.parseShort(day));
                ++n;
            }
        }
        stringArray = months = expr[4].split(",");
        n2 = months.length;
        n = 0;
        while (n < n2) {
            String month = stringArray[n];
            conf.months.add((short)(Short.parseShort(month) - 1));
            ++n;
        }
        return conf;
    }

    private static void checkDaysAndMonthsCombinationInvalid(List<Short> days, List<Short> months) throws DBException {
        if (days.isEmpty() || months.isEmpty()) {
            throw new DBException("Days or months are not specified");
        }
        if (days.size() == 1 && days.contains((short)32)) {
            throw new DBException("'Last day' is not supported by cron");
        }
        int maxSupportedDay = 0;
        for (Short m : months) {
            int maxLength = Month.of(m + 1).maxLength();
            if (maxLength <= maxSupportedDay) continue;
            maxSupportedDay = maxLength;
        }
        for (Short d : days) {
            if (d <= maxSupportedDay) continue;
            throw new DBException("There is no day #" + String.valueOf(d) + " in provided months");
        }
    }

    private static String getMinuteHourPart(DBTTaskScheduleConfiguration cfg) {
        Calendar calendar = GregorianCalendar.getInstance(TimeZone.getTimeZone(TimezoneRegistry.getUserDefaultTimezone()));
        calendar.setTime(cfg.startTime);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        return minute + " " + hour;
    }

    private static String getCronExpressionForWeeklyTask(DBTTaskScheduleConfiguration cfg) throws DBException {
        List weekdays = cfg.days;
        if (weekdays.isEmpty()) {
            throw new DBException("Unable to generate cron expression for weekly task. No weekdays provided.");
        }
        StringBuilder expr = new StringBuilder(ConfigurationConverter.getMinuteHourPart(cfg) + " * * ");
        expr.append(ConfigurationConverter.toCronWeekday((Short)weekdays.get(0)));
        int i = 1;
        while (i < weekdays.size()) {
            expr.append(',').append(ConfigurationConverter.toCronWeekday((Short)weekdays.get(i)));
            ++i;
        }
        return expr.toString();
    }

    private static int toCronWeekday(Short dbtTaskScheduleConfigurationWeekday) {
        if (dbtTaskScheduleConfigurationWeekday < 1 || dbtTaskScheduleConfigurationWeekday > 7) {
            throw new IllegalArgumentException("Illegal weekday <" + String.valueOf(dbtTaskScheduleConfigurationWeekday) + "> from DBTTaskScheduleConfiguration");
        }
        return dbtTaskScheduleConfigurationWeekday - 1;
    }

    private static short toDBTTaskScheduleConfigurationWeekday(int cronWeekday) {
        if (cronWeekday < 0 || cronWeekday > 6) {
            throw new IllegalArgumentException("Illegal weekday <" + cronWeekday + "> from cron expression");
        }
        return (short)(cronWeekday + 1);
    }
}

