/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.bigquery.model.data;

import com.dbeaver.db.bigquery.model.BigQueryDialect;
import com.dbeaver.db.bigquery.model.BigQueryResultSet;
import com.dbeaver.db.bigquery.model.BigQueryUtils;
import com.dbeaver.db.bigquery.model.data.BigQueryTraceProperty;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.trace.DBCTraceDynamic;
import org.jkiss.dbeaver.model.exec.trace.DBCTraceProperty;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.BeanUtils;

public class BigQueryTrace
implements DBCTraceDynamic {
    private static final Log log = Log.getLog(BigQueryTrace.class);
    private final NumberFormat numberFormat = new DecimalFormat();
    private final JDBCExecutionContext executionContext;
    private String location;
    private String jobId;
    private final List<DBCTraceProperty> traceProperties = new ArrayList<DBCTraceProperty>();
    private boolean hasExtraProperties;

    public BigQueryTrace(@NotNull BigQueryResultSet resultSet) {
        this.executionContext = resultSet.getSession().getExecutionContext();
        try {
            Object dmlStats;
            Object jobReference;
            Object mResultSet = BeanUtils.getInheritedFieldValue((Object)resultSet.getOriginal(), (String)"m_resultSet");
            if (mResultSet == null) {
                return;
            }
            Object mDataHandler = BeanUtils.getInheritedFieldValue((Object)mResultSet, (String)"m_dataHandler");
            Object mBqResults = mDataHandler == null ? null : BeanUtils.getInheritedFieldValue((Object)mDataHandler, (String)"m_bqResults");
            Object mQueryResponse = mBqResults == null ? null : BeanUtils.getInheritedFieldValue((Object)mBqResults, (String)"m_queryResponse");
            Object object = jobReference = mQueryResponse == null ? null : BeanUtils.invokeObjectMethod((Object)mQueryResponse, (String)"getJobReference");
            if (jobReference != null) {
                this.addProperty(jobReference, "getJobId", "Job");
                this.addProperty(jobReference, "getLocation", "Location");
                this.addProperty(jobReference, "getProjectId", "Project");
            }
            if (mQueryResponse != null) {
                this.addProperty(mQueryResponse, "getNumDmlAffectedRows", "DML affected rows");
            }
            Object object2 = dmlStats = mQueryResponse == null ? null : BeanUtils.invokeObjectMethod((Object)mQueryResponse, (String)"getDmlStats");
            if (dmlStats != null) {
                this.addProperty(dmlStats, "getDeletedRowCount", "DML deleted");
                this.addProperty(dmlStats, "getInsertedRowCount", "DML inserted");
                this.addProperty(dmlStats, "getUpdatedRowCount", "DML updated");
            }
            if (mQueryResponse != null) {
                this.addProperty(mQueryResponse, "getCacheHit", "Fetched from cache");
                this.addProperty(mQueryResponse, "getTotalRows", "Total rows", this.numberFormat);
                this.addProperty(mQueryResponse, "getTotalBytesProcessed", "Total bytes processed", this.numberFormat);
            }
            if (jobReference != null) {
                this.location = (String)BeanUtils.invokeObjectMethod((Object)jobReference, (String)"getLocation");
                this.jobId = (String)BeanUtils.invokeObjectMethod((Object)jobReference, (String)"getJobId");
            }
        }
        catch (Throwable e) {
            log.debug((Object)e);
        }
    }

    private void addProperty(Object jobReference, String methodName, String propName) {
        try {
            Object objectValue = BeanUtils.invokeObjectMethod((Object)jobReference, (String)methodName);
            String value = "none";
            if (objectValue != null) {
                value = String.valueOf(objectValue);
            }
            BigQueryTraceProperty prop = new BigQueryTraceProperty(propName, value == null ? "none" : String.valueOf(value));
            this.traceProperties.add(prop);
        }
        catch (Throwable e) {
            log.debug((Object)e);
        }
    }

    private void addProperty(Object jobReference, String methodName, String propName, NumberFormat numberFormat) {
        try {
            Object value = BeanUtils.invokeObjectMethod((Object)jobReference, (String)methodName);
            BigQueryTraceProperty prop = new BigQueryTraceProperty(propName, numberFormat.format(value));
            this.traceProperties.add(prop);
        }
        catch (Throwable e) {
            log.debug((Object)e);
        }
    }

    private void addProperty(String propName, NumberFormat numberFormat, Object value) {
        try {
            BigQueryTraceProperty prop = new BigQueryTraceProperty(propName, numberFormat.format(value));
            this.traceProperties.add(prop);
        }
        catch (Throwable e) {
            log.debug((Object)e);
        }
    }

    private void addProperty(String propName, Object value) {
        try {
            BigQueryTraceProperty prop = new BigQueryTraceProperty(propName, value == null ? "none" : String.valueOf(value));
            this.traceProperties.add(prop);
        }
        catch (Throwable e) {
            log.debug((Object)e);
        }
    }

    public boolean hasDynamicProperties() {
        return true;
    }

    public List<DBCTraceProperty> getTraceProperties(DBRProgressMonitor monitor) {
        if (!this.hasExtraProperties) {
            this.readExtraProperties();
        }
        return this.traceProperties;
    }

    private void readExtraProperties() {
        if (this.location == null || this.jobId == null) {
            return;
        }
        this.hasExtraProperties = true;
        if (BigQueryUtils.getCurrentDialect((DBSObject)this.executionContext.getDataSource()) != BigQueryDialect.SQL) {
            return;
        }
        String sql = "SELECT * FROM region-" + this.location + ".INFORMATION_SCHEMA.JOBS_BY_USER WHERE job_id = ?";
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (JDBCSession session = this.executionContext.openSession((DBRProgressMonitor)new VoidProgressMonitor(), DBCExecutionPurpose.USER, "Read BigQuery statistics");){
                Throwable throwable2 = null;
                Object var6_10 = null;
                try (JDBCPreparedStatement statement = session.prepareStatement(sql);){
                    statement.setString(1, this.jobId);
                    Throwable throwable3 = null;
                    Object var9_15 = null;
                    try (JDBCResultSet dbResult = statement.executeQuery();){
                        if (dbResult.next()) {
                            this.addProperty("Transaction id", dbResult.getString("transaction_id"));
                            this.addProperty("Total bytes billed", this.numberFormat, dbResult.getInt("total_bytes_billed"));
                            this.addProperty("Total modified partitions", this.numberFormat, dbResult.getInt("total_modified_partitions"));
                            this.addProperty("Total slot ms", this.numberFormat, dbResult.getInt("total_slot_ms"));
                            this.addProperty("Query", dbResult.getString("query"));
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }
}

