/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.bigquery.model;

import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericUniqueKey;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;

public class BigQueryUniqueKey
extends GenericUniqueKey {
    private String projectName;
    private String schemaName;
    private String tableName;
    private String columnName;
    private int ordinalPosition;
    private Integer positionInUniquieConstraint;

    public BigQueryUniqueKey(String projectName, String schemaName, GenericTableBase table, String columnName, String constraintName, String remarks, DBSEntityConstraintType constraintType, boolean persisted, int ordinalPosition, @Nullable Integer positionInUniquieConstraint) {
        super(table, constraintName, remarks, constraintType, persisted);
        this.projectName = projectName;
        this.schemaName = schemaName;
        this.tableName = table.getName();
        this.columnName = columnName;
        this.ordinalPosition = ordinalPosition;
        this.positionInUniquieConstraint = positionInUniquieConstraint;
    }

    public BigQueryUniqueKey(GenericTableBase table, String constraintName, @Nullable String remarks, DBSEntityConstraintType constraintType, JDBCResultSet dbResult, boolean persisted) {
        super(table, constraintName, remarks, constraintType, persisted);
    }

    @Property(viewable=true, order=1)
    public String getProjectName() {
        return this.projectName;
    }

    @Property(viewable=true, order=2)
    public String getSchemaName() {
        return this.schemaName;
    }

    @Property(viewable=true, order=6)
    public String getTableName() {
        return this.tableName;
    }

    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    @Property(viewable=true, order=3)
    public String getPositionInUniquieConstraint() {
        if (this.positionInUniquieConstraint == null) {
            return "NULL";
        }
        return String.valueOf(this.positionInUniquieConstraint);
    }

    @Property(viewable=true, order=4)
    public String getColumnName() {
        return this.columnName;
    }
}

