/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.bigquery.model;

import com.dbeaver.db.bigquery.model.BigQueryDataSourcePro;
import com.dbeaver.db.bigquery.model.BigQueryDataset;
import com.dbeaver.db.bigquery.model.BigQueryMLModel;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.paging.Page;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.Model;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.BasicObjectCache;

public class BigQueryMLModelCache
extends BasicObjectCache<BigQueryDataset, BigQueryMLModel> {
    @NotNull
    public Collection<BigQueryMLModel> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable BigQueryDataset dataset) throws DBException {
        if (!this.isFullyCached() && !monitor.isForceCacheUsage()) {
            BigQuery bigQuery;
            GenericDataSource genericDs = dataset.getDataSource();
            BigQueryDataSourcePro dsPro = (BigQueryDataSourcePro)genericDs;
            CredentialsProvider credentialsProvider = dsPro.getCredentialsProvider();
            try {
                bigQuery = (BigQuery)((BigQueryOptions.Builder)((BigQueryOptions.Builder)BigQueryOptions.newBuilder().setProjectId(dataset.getParentObject().getName())).setCredentials(credentialsProvider.getCredentials())).build().getService();
            }
            catch (IOException e) {
                throw new DBException("Error instantiating instance bigquery client", (Throwable)e);
            }
            List<BigQueryMLModel> models = this.listModels((DBSObject)dataset, dataset.getName(), bigQuery);
            this.setCache(models);
            return models;
        }
        return this.getCachedObjects();
    }

    private List<BigQueryMLModel> listModels(@NotNull DBSObject parent, @NotNull String datasetName, @NotNull BigQuery bigQuery) throws DBException {
        ArrayList<BigQueryMLModel> models = new ArrayList<BigQueryMLModel>();
        try {
            Page modelPage = bigQuery.listModels(datasetName, new BigQuery.ModelListOption[]{BigQuery.ModelListOption.pageSize((long)100L)});
            if (modelPage == null) {
                return models;
            }
            for (Model model : modelPage.iterateAll()) {
                Date created = model.getCreationTime() != null ? new Date(model.getCreationTime()) : null;
                Date modified = model.getLastModifiedTime() != null ? new Date(model.getLastModifiedTime()) : null;
                Date expires = model.getExpirationTime() != null ? new Date(model.getExpirationTime()) : null;
                models.add(new BigQueryMLModel(parent, model.getModelId().getModel(), model.getDescription(), model.getModelType(), created, modified, expires, model.getLocation()));
            }
        }
        catch (Exception e) {
            throw new DBException("Failed to load ML models: " + e.getMessage(), (Throwable)e);
        }
        return models;
    }
}

