/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.bigquery.model;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.utils.CommonUtils;

public class BiQueryTypeNameParser {
    private final String typeName;
    private int curIndex = 0;

    public BiQueryTypeNameParser(String typeName) {
        this.typeName = typeName;
    }

    String nextIdentifier() {
        char c;
        int i = this.curIndex;
        while (i < this.typeName.length()) {
            c = this.typeName.charAt(i);
            if (Character.isWhitespace(c) || c == '<' || c == ',') {
                ++this.curIndex;
            } else {
                if (c != '>') break;
                ++this.curIndex;
                return null;
            }
            ++i;
        }
        i = this.curIndex;
        while (i < this.typeName.length()) {
            c = this.typeName.charAt(i);
            if (!Character.isJavaIdentifierPart(c)) {
                String identifier = this.typeName.substring(this.curIndex, i);
                this.curIndex = i;
                return identifier;
            }
            ++i;
        }
        return this.typeName.substring(this.curIndex);
    }

    public void skipTypeDeclaration() {
        int i = this.curIndex;
        while (i < this.typeName.length()) {
            char c = this.typeName.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                return;
            }
            if (c == '<' || c == '>') {
                this.curIndex = i + 1;
                break;
            }
            ++i;
        }
    }

    public SubType nextSubType() {
        String shortTypeName = this.nextIdentifier();
        if (shortTypeName == null) {
            return null;
        }
        return switch (shortTypeName) {
            case "STRUCT" -> new StructType();
            case "ARRAY" -> new ArrayType();
            default -> new SimpleType(shortTypeName);
        };
    }

    public static class ArrayType
    extends SubType {
        private SubType itemType;

        public ArrayType() {
            super("ARRAY");
        }

        @Override
        public Map<String, SubType> getNestedItems() {
            return this.itemType.getNestedItems();
        }

        public SubType getItemType() {
            return this.itemType;
        }

        @Override
        public void parse(BiQueryTypeNameParser parser) {
            parser.skipTypeDeclaration();
            this.itemType = parser.nextSubType();
            this.itemType.parse(parser);
            parser.skipTypeDeclaration();
        }
    }

    public static class SimpleType
    extends SubType {
        public SimpleType(String name) {
            super(name);
        }

        @Override
        public Map<String, SubType> getNestedItems() {
            return null;
        }

        @Override
        public void parse(BiQueryTypeNameParser parser) {
        }
    }

    public static class StructType
    extends SubType {
        private final Map<String, SubType> fields = new LinkedHashMap<String, SubType>();

        public StructType() {
            super("STRUCT");
        }

        @Override
        public Map<String, SubType> getNestedItems() {
            return this.fields;
        }

        @Override
        public void parse(BiQueryTypeNameParser parser) {
            String fieldName;
            parser.skipTypeDeclaration();
            while (!CommonUtils.isEmpty((String)(fieldName = parser.nextIdentifier()))) {
                SubType item = parser.nextSubType();
                this.fields.put(fieldName, item);
                item.parse(parser);
            }
        }
    }

    public static abstract class SubType {
        private final String name;

        public SubType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public abstract Map<String, SubType> getNestedItems();

        public abstract void parse(BiQueryTypeNameParser var1);
    }
}

