/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.management.implementation.polling;

import com.azure.core.http.HttpHeaders;
import com.azure.core.management.implementation.polling.Error;
import com.azure.core.management.implementation.polling.FinalResult;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonProviders;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.net.URL;
import java.util.Objects;

final class ProvisioningStateData
implements JsonSerializable<ProvisioningStateData> {
    @JsonProperty(value="pollUrl", required=true)
    private URL pollUrl;
    @JsonProperty(value="provisioningState", required=true)
    private String provisioningState;
    @JsonProperty(value="pollError")
    private Error pollError;
    @JsonProperty(value="finalResult")
    private FinalResult finalResult;

    ProvisioningStateData() {
    }

    ProvisioningStateData(URL pollUrl, String provisioningState) {
        this.pollUrl = Objects.requireNonNull(pollUrl, "'pollUrl' cannot be null.");
        this.provisioningState = Objects.requireNonNull(provisioningState, "'provisioningState' cannot be null.");
    }

    String getProvisioningState() {
        return this.provisioningState;
    }

    URL getPollUrl() {
        return this.pollUrl;
    }

    Error getPollError() {
        return this.pollError;
    }

    FinalResult getFinalResult() {
        return this.finalResult;
    }

    void update(int pollResponseStatusCode, HttpHeaders pollResponseHeaders, String pollResponseBody) {
        if (pollResponseStatusCode != 200) {
            this.provisioningState = "Failed";
            this.pollError = new Error("Polling failed with status code:" + pollResponseStatusCode, pollResponseStatusCode, pollResponseHeaders.toMap(), pollResponseBody);
            return;
        }
        String value = ProvisioningStateData.tryParseProvisioningState(pollResponseBody);
        if (value == null) {
            this.provisioningState = "Failed";
            this.pollError = new Error("Polling response does not contain a valid body.", pollResponseStatusCode, pollResponseHeaders.toMap(), pollResponseBody);
            return;
        }
        this.provisioningState = value;
        if ("Failed".equalsIgnoreCase(this.provisioningState) || "Canceled".equalsIgnoreCase(this.provisioningState)) {
            this.pollError = new Error("Long running operation failed or cancelled.", pollResponseStatusCode, pollResponseHeaders.toMap(), pollResponseBody);
        } else if ("Succeeded".equalsIgnoreCase(this.provisioningState)) {
            this.finalResult = new FinalResult(null, pollResponseBody);
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeStartObject().writeStringField("pollUrl", Objects.toString(this.pollUrl, null)).writeStringField("provisioningState", this.provisioningState).writeJsonField("pollError", (JsonSerializable)this.pollError).writeJsonField("finalResult", (JsonSerializable)this.finalResult).writeEndObject();
    }

    public static ProvisioningStateData fromJson(JsonReader jsonReader) throws IOException {
        return (ProvisioningStateData)jsonReader.readObject(reader -> {
            ProvisioningStateData provisioningStateData = new ProvisioningStateData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("pollUrl".equals(fieldName)) {
                    provisioningStateData.pollUrl = (URL)reader.getNullable(nonNullReader -> new URL(reader.getString()));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    provisioningStateData.provisioningState = reader.getString();
                    continue;
                }
                if ("pollError".equals(fieldName)) {
                    provisioningStateData.pollError = Error.fromJson(reader);
                    continue;
                }
                if ("finalResult".equals(fieldName)) {
                    provisioningStateData.finalResult = FinalResult.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return provisioningStateData;
        });
    }

    static String tryParseProvisioningState(String value) {
        String string;
        block9: {
            if (CoreUtils.isNullOrEmpty((CharSequence)value)) {
                return null;
            }
            JsonReader jsonReader = JsonProviders.createReader((String)value);
            try {
                ResourceWithProvisioningState resource = ResourceWithProvisioningState.fromJson(jsonReader);
                String string2 = string = resource != null ? resource.getProvisioningState() : null;
                if (jsonReader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (jsonReader != null) {
                        try {
                            jsonReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ignored) {
                    return null;
                }
            }
            jsonReader.close();
        }
        return string;
    }

    private static class ResourceWithProvisioningState
    implements JsonSerializable<ResourceWithProvisioningState> {
        @JsonProperty(value="properties")
        private Properties properties;

        private ResourceWithProvisioningState() {
        }

        private String getProvisioningState() {
            if (this.properties != null) {
                return this.properties.provisioningState;
            }
            return null;
        }

        public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
            return jsonWriter.writeStartObject().writeJsonField("properties", (JsonSerializable)this.properties).writeEndObject();
        }

        public static ResourceWithProvisioningState fromJson(JsonReader jsonReader) throws IOException {
            return (ResourceWithProvisioningState)jsonReader.readObject(reader -> {
                ResourceWithProvisioningState resourceWithProvisioningState = new ResourceWithProvisioningState();
                while (reader.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = reader.getFieldName();
                    reader.nextToken();
                    if ("properties".equals(fieldName)) {
                        resourceWithProvisioningState.properties = Properties.fromJson(reader);
                        continue;
                    }
                    reader.skipChildren();
                }
                return resourceWithProvisioningState;
            });
        }

        private static class Properties
        implements JsonSerializable<Properties> {
            @JsonProperty(value="provisioningState")
            private String provisioningState;

            private Properties() {
            }

            public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
                return jsonWriter.writeStartObject().writeStringField("provisioningState", this.provisioningState).writeEndObject();
            }

            public static Properties fromJson(JsonReader jsonReader) throws IOException {
                return (Properties)jsonReader.readObject(reader -> {
                    Properties properties = new Properties();
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        String fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("provisioningState".equals(fieldName)) {
                            properties.provisioningState = reader.getString();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    return properties;
                });
            }
        }
    }
}

