/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.transfer.parquet.schema;

import com.dbeaver.data.transfer.parquet.schema.AbstractParquetExportSchemaFactory;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;

public class ParquetExportSchemaFactoryNonJdbc
extends AbstractParquetExportSchemaFactory {
    public ParquetExportSchemaFactoryNonJdbc(DBDAttributeBinding[] attributeBindings, String dataContainerName, Object[] row) {
        super(attributeBindings, dataContainerName, row);
    }

    @Override
    public MessageType getParquetSchema() {
        Types.MessageTypeBuilder builder = Types.buildMessage();
        int i = 0;
        while (i < this.attributeBindings.length) {
            DBDAttributeBinding attributeBinding = this.attributeBindings[i];
            String columnName = attributeBinding.getName();
            DBPDataKind dataKind = attributeBinding.getDataKind();
            switch (dataKind) {
                case BOOLEAN: {
                    builder.addField((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN).named(columnName));
                    break;
                }
                case NUMERIC: {
                    Integer scale = attributeBinding.getScale();
                    if (scale == null || scale == 0) {
                        builder.addField((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).named(columnName));
                        break;
                    }
                    builder.addField((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE).named(columnName));
                    break;
                }
                case DATETIME: {
                    if (this.addStringTypeColumnIfDatetimeWithoutType(i, builder)) break;
                    builder.addField((Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS))).named(columnName));
                    break;
                }
                default: {
                    builder.addField((Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named(columnName));
                }
            }
            ++i;
        }
        return builder.named(this.dataContainerName);
    }
}

