/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.cyberark;

import com.dbeaver.model.auth.SMAuthUtils;
import com.dbeaver.model.cyberark.CyberArkParametersProviderConfiguration;
import com.dbeaver.model.datasource.DataSourceDescriptorPRO;
import com.dbeaver.model.datasource.parameters.DBPAbstractParametersProvider;
import com.dbeaver.model.datasource.parameters.DBPDatasourceExternalParameters;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.auth.SMSessionPersistent;
import org.jkiss.dbeaver.model.impl.app.CertificateGenHelper;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.function.ThrowableFunction;

public class CyberArkParametersProvider
extends DBPAbstractParametersProvider<CyberArkParametersProviderConfiguration> {
    private static final Log log = Log.getLog(CyberArkParametersProvider.class);
    public static final String CYBERARK_PROVIDER_ID = "cyberark-parameters-provider";
    public static final String CYBERARK_TOKEN_ATTRIBUTE = "cyberark-token-";
    private static final int TTL = 480;
    private static final String URL_FETCH_SECRET = "%s/secrets/%s/variable/%s";
    private static final String URL_LIST_VARIABLES = "%s/resources/%s?kind=variable&search=%s";
    private static final String URL_AUTHENTICATE = "%s/authn/%s/%s/authenticate";

    @Nullable
    public Map<String, ?> readParameters(@NotNull DBRProgressMonitor monitor, @NotNull DataSourceDescriptorPRO dataSourceDescriptor) throws DBException {
        DBPDatasourceExternalParameters datasourceParametersConfig = dataSourceDescriptor.getExternalParametersConfig();
        if (datasourceParametersConfig == null) {
            return null;
        }
        CyberArkParametersProviderConfiguration config = (CyberArkParametersProviderConfiguration)this.getConfiguration(datasourceParametersConfig, CyberArkParametersProviderConfiguration.class);
        this.validate(config);
        try {
            SMSessionPersistent session = CyberArkParametersProvider.getSession(monitor, dataSourceDescriptor);
            String pathToSecret = this.buildSecretPath(config, datasourceParametersConfig);
            HttpClient client = this.createHttpClient(config);
            List<String> variables = this.fetchVariables(monitor, dataSourceDescriptor, session, client, config, pathToSecret);
            return this.fetchValues(monitor, dataSourceDescriptor, variables, session, config, client);
        }
        catch (DBException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DBException("Error reading CyberArk secrets: " + e.getMessage(), (Throwable)e);
        }
    }

    public CyberArkParametersProviderConfiguration createDefaultConfiguration() {
        return new CyberArkParametersProviderConfiguration("");
    }

    @NotNull
    private Map<String, String> fetchValues(@NotNull DBRProgressMonitor monitor, @NotNull DataSourceDescriptorPRO dataSourceDescriptor, @NotNull List<String> variables, @NotNull SMSessionPersistent session, @NotNull CyberArkParametersProviderConfiguration config, @NotNull HttpClient client) throws DBException {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String variableId : variables) {
            String secretValue = (String)this.retryOnUnauthorized(monitor, session, client, config, dataSourceDescriptor, t -> this.retrieveVariable(config, client, (String)t, variableId));
            if (CommonUtils.isEmpty((String)secretValue)) continue;
            result.put(this.extractKey(variableId), secretValue);
        }
        return result;
    }

    @NotNull
    public String resolveToken(@NotNull DBRProgressMonitor monitor, @NotNull SMSessionPersistent session, @NotNull HttpClient client, @NotNull CyberArkParametersProviderConfiguration config, @NotNull DataSourceDescriptorPRO dataSourceDescriptor, boolean forceRenew) throws IOException, DBException, InterruptedException {
        CyberArkTokenAdapter cached;
        String cacheKey = CYBERARK_TOKEN_ATTRIBUTE + config.getConfigurationId();
        if (!forceRenew && (cached = (CyberArkTokenAdapter)session.getAttribute(cacheKey)) != null && !cached.isExpired() && cached.version.equals(config.getVersion())) {
            return cached.token();
        }
        URI uri = this.createUri(config, URL_AUTHENTICATE, config.getUsername());
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Content-Type", "text/plain; charset=UTF-8").POST(HttpRequest.BodyPublishers.ofString(config.getApiKey(), StandardCharsets.UTF_8)).build();
        HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
        int status = response.statusCode();
        if (status != 200) {
            throw new DBException("CyberArk authentication failed: HTTP " + status);
        }
        String rawToken = response.body();
        String token = Base64.getEncoder().encodeToString(rawToken.getBytes(StandardCharsets.UTF_8));
        LocalDateTime expirationTime = LocalDateTime.now().plusSeconds(480L);
        session.setAttribute(cacheKey, (Object)new CyberArkTokenAdapter(token, expirationTime, config.getVersion()));
        return token;
    }

    @NotNull
    private List<String> fetchVariables(@NotNull DBRProgressMonitor monitor, @NotNull DataSourceDescriptorPRO dataSourceDescriptor, @NotNull SMSessionPersistent session, @NotNull HttpClient client, @NotNull CyberArkParametersProviderConfiguration config, @NotNull String pathToSecret) throws DBException {
        return (List)this.retryOnUnauthorized(monitor, session, client, config, dataSourceDescriptor, t -> this.listVariables(config, client, (String)t, pathToSecret));
    }

    @NotNull
    private static SMSessionPersistent getSession(@NotNull DBRProgressMonitor monitor, @NotNull DataSourceDescriptorPRO dataSourceDescriptor) throws DBException {
        SMSessionPersistent sessionPersistent = SMAuthUtils.findSessionPersistent((DBRProgressMonitor)monitor, (DBPProject)dataSourceDescriptor.getProject());
        if (sessionPersistent == null) {
            throw new DBException("No persistent session for " + dataSourceDescriptor.getProject().getDisplayName());
        }
        return sessionPersistent;
    }

    @Nullable
    private List<String> listVariables(@NotNull CyberArkParametersProviderConfiguration config, @NotNull HttpClient client, @NotNull String token, @NotNull String secretPath) throws IOException, DBException, InterruptedException {
        HttpRequest request = this.createRequest(config, token, URL_LIST_VARIABLES, secretPath);
        HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
        int responseCode = response.statusCode();
        if (responseCode == 401) {
            return null;
        }
        CyberArkParametersProvider.validateHttpStatus(responseCode, "Secret not found: " + secretPath);
        String json = response.body();
        if (CommonUtils.isEmpty((String)json)) {
            return List.of();
        }
        return this.parseVariableIds(json);
    }

    @Nullable
    private String retrieveVariable(@NotNull CyberArkParametersProviderConfiguration config, @NotNull HttpClient client, @NotNull String token, @NotNull String variablePath) throws IOException, DBException, InterruptedException {
        HttpRequest request = this.createRequest(config, token, URL_FETCH_SECRET, variablePath);
        HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
        int responseCode = response.statusCode();
        if (responseCode == 401) {
            return null;
        }
        CyberArkParametersProvider.validateHttpStatus(responseCode, "Variable is missing or has no value: " + variablePath);
        return response.body();
    }

    private static void validateHttpStatus(int status, @NotNull String notFoundMessage) throws DBException {
        if (status == 404) {
            throw new DBException(notFoundMessage);
        }
        if (status != 200) {
            throw new DBException("HTTP request failed: " + status);
        }
    }

    @NotNull
    private HttpClient createHttpClient(@NotNull CyberArkParametersProviderConfiguration config) throws DBException {
        try {
            HttpClient.Builder builder = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL);
            if (config.isTrustCertificate()) {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, CertificateGenHelper.NON_VALIDATING_TRUST_MANAGERS, new SecureRandom());
                builder.sslContext(sslContext);
            }
            return builder.build();
        }
        catch (Exception e) {
            throw new DBException("Failed to initialize HTTP client", (Throwable)e);
        }
    }

    @NotNull
    private URI createUri(@NotNull CyberArkParametersProviderConfiguration config, @NotNull String urlTemplate, @NotNull String param) {
        String encodedUsername = URLEncoder.encode(param, StandardCharsets.UTF_8);
        return URI.create(String.format(urlTemplate, this.normalizeBaseUrl(config.getBaseUrl()), this.normalizePath(config.getAccount()), encodedUsername));
    }

    @NotNull
    private HttpRequest createRequest(@NotNull CyberArkParametersProviderConfiguration config, @NotNull String token, @NotNull String urlTemplate, @NotNull String pathParam) {
        URI uri = this.createUri(config, urlTemplate, pathParam);
        return HttpRequest.newBuilder().uri(uri).header("Authorization", "Token token=\"" + token + "\"").GET().build();
    }

    @NotNull
    private <T> T retryOnUnauthorized(@NotNull DBRProgressMonitor monitor, @NotNull SMSessionPersistent session, @NotNull HttpClient client, @NotNull CyberArkParametersProviderConfiguration config, @NotNull DataSourceDescriptorPRO ds, @NotNull ThrowableFunction<String, T, Exception> action) throws DBException {
        try {
            String token = this.resolveToken(monitor, session, client, config, ds, false);
            Object result = action.apply((Object)token);
            if (result != null) {
                return (T)result;
            }
            return (T)action.apply((Object)this.resolveToken(monitor, session, client, config, ds, true));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new DBException("CyberArk request failed", (Throwable)e);
        }
        catch (Exception e) {
            throw new DBException("CyberArk request failed", (Throwable)e);
        }
    }

    @NotNull
    private List<String> parseVariableIds(@NotNull String json) {
        ArrayList<String> ids = new ArrayList<String>();
        JsonArray array = JsonParser.parseString((String)json).getAsJsonArray();
        for (JsonElement e : array) {
            String id = e.getAsJsonObject().get("id").getAsString();
            ids.add(id.substring(id.indexOf(58, id.indexOf(58) + 1) + 1).replaceFirst("^variable:", ""));
        }
        return ids;
    }

    @NotNull
    private String normalizePath(@NotNull String value) {
        return CommonUtils.removeTrailingSlash((String)CommonUtils.removeLeadingSlash((String)value));
    }

    @NotNull
    private String normalizeBaseUrl(@NotNull String url) {
        return CommonUtils.removeTrailingSlash((String)url);
    }

    @NotNull
    private String buildSecretPath(@NotNull CyberArkParametersProviderConfiguration config, @NotNull DBPDatasourceExternalParameters dsConfig) {
        return this.normalizePath(config.getPolicyBranch()) + "/" + this.normalizePath(dsConfig.getSecretName());
    }

    @NotNull
    private String extractKey(@NotNull String variableId) {
        return variableId.substring(variableId.lastIndexOf(47) + 1);
    }

    private void validate(@NotNull CyberArkParametersProviderConfiguration config) throws DBException {
        if (CommonUtils.isEmpty((String)config.getApiKey())) {
            throw new DBException("CyberArk token is not valid");
        }
    }

    record CyberArkTokenAdapter(@NotNull String token, @NotNull LocalDateTime expirationTime, @NotNull String version) {
        public boolean isExpired() {
            return LocalDateTime.now().isAfter(this.expirationTime);
        }
    }
}

