/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.rag.storage.sqlite;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.Statement;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPDriverLibrary;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public interface SQLiteExtension {
    public String name();

    public boolean isLoaded(Connection var1) throws DBException;

    default public void loadExtension(@NotNull DBPDriver driver, @NotNull Connection connection) throws DBException {
        String extensionPath = this.extensionFilePath(driver).toAbsolutePath().toString().replace("\\", "\\\\");
        String loadExtensionSQL = "SELECT load_extension('" + extensionPath + "')";
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (Statement statement = connection.createStatement();){
                statement.execute(loadExtensionSQL);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new DBException("Error loading SQLite extension from " + extensionPath, (Throwable)e);
        }
    }

    default public Path extensionFilePath(@NotNull DBPDriver driver) throws DBException {
        Path sqLiteDriver = driver.getDriverLibraries().stream().map(DBPDriverLibrary::getLocalFile).filter(Objects::nonNull).findFirst().orElseThrow(() -> new DBException("SQLite extension library not found"));
        Path extensionsFolder = sqLiteDriver.getParent().resolve("extensions").resolve(this.name());
        if (Files.notExists(extensionsFolder, new LinkOption[0])) {
            throw new DBException("SQLite extension folder not found: " + String.valueOf(extensionsFolder));
        }
        AtomicReference<Path> finalPath = new AtomicReference<Path>(extensionsFolder);
        Stream.of(Platform.getOS(), RuntimeUtils.isWindows() ? null : Platform.getOSArch()).filter(Objects::nonNull).forEach(part -> finalPath.set(((Path)finalPath.get()).resolve((String)part)));
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (Stream<Path> stream = Files.list(finalPath.get());){
                return stream.filter(it -> {
                    try {
                        return !Files.isHidden(it);
                    }
                    catch (IOException iOException) {
                        return false;
                    }
                }).findFirst().orElseThrow(() -> new DBException("SQLite extension file not found in: " + String.valueOf(finalPath.get())));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new DBException("Error accessing SQLite extension folder: " + String.valueOf(finalPath.get()), (Throwable)e);
        }
    }
}

