/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.rag.storage.sqlite;

import com.dbeaver.model.ai.RAGDatasourceKey;
import com.dbeaver.model.ai.RAGEmbeddedRecord;
import com.dbeaver.model.ai.RAGObjectKey;
import com.dbeaver.model.ai.RAGRelevantRecordFilter;
import com.dbeaver.model.ai.rag.storage.RAGAbstractEmbeddingStorage;
import com.dbeaver.model.ai.rag.storage.RAGDatabase;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;

public class RAGSQLiteEmbeddingStorage
extends RAGAbstractEmbeddingStorage {
    private static final Log log = Log.getLog(RAGSQLiteEmbeddingStorage.class);
    private static final DateTimeFormatter TIMESTAMP_FMT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneOffset.UTC);

    protected RAGSQLiteEmbeddingStorage(@NotNull RAGDatabase ragDatabase) {
        super(ragDatabase);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void save(@NotNull Collection<RAGEmbeddedRecord> records) throws DBException {
        if (!records.iterator().hasNext()) {
            return;
        }
        List<String> keys = records.stream().map(record -> record.key().asString()).toList();
        String deleteSql = "DELETE FROM {table_prefix}ai_object_index WHERE object_key IN (" + keys.stream().map(k -> "?").collect(Collectors.joining(",")) + ")";
        String insertSql = "INSERT INTO {table_prefix}ai_object_index (object_key, embedding, checksum, model_name)\nVALUES (?, vec_f32(?), ?, ?)\n";
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (Connection connection = this.getConnection();){
                Throwable throwable2 = null;
                Object var9_13 = null;
                try {
                    PreparedStatement deleteStmt = connection.prepareStatement(deleteSql);
                    try {
                        try (PreparedStatement insertStmt = connection.prepareStatement(insertSql);){
                            connection.setAutoCommit(false);
                            int i = 0;
                            while (i < keys.size()) {
                                deleteStmt.setString(i + 1, keys.get(i));
                                ++i;
                            }
                            deleteStmt.executeUpdate();
                            int count = 0;
                            for (RAGEmbeddedRecord record2 : records) {
                                insertStmt.setString(1, record2.key().asString());
                                insertStmt.setBytes(2, RAGSQLiteEmbeddingStorage.f32ToBlob(record2.embedding()));
                                insertStmt.setLong(3, record2.checksum());
                                insertStmt.setString(4, record2.modelName());
                                insertStmt.addBatch();
                                if (++count % 1000 != 0) continue;
                                insertStmt.executeBatch();
                            }
                            insertStmt.executeBatch();
                            connection.commit();
                        }
                        if (deleteStmt == null) return;
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        if (deleteStmt == null) throw throwable2;
                        deleteStmt.close();
                        throw throwable2;
                    }
                    deleteStmt.close();
                    return;
                }
                catch (Throwable throwable4) {
                    if (throwable2 == null) {
                        throwable2 = throwable4;
                        throw throwable2;
                    } else {
                        if (throwable2 == throwable4) throw throwable2;
                        throwable2.addSuppressed(throwable4);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                } else {
                    if (throwable == throwable5) throw throwable;
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Error saving embedded records", (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    @NotNull
    public List<RAGEmbeddedRecord> findRelevantRecords0(@NotNull RAGRelevantRecordFilter filter) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    @NotNull
    public List<RAGDatasourceKey> findStaleDatasources(@NotNull Instant olderThan) throws DBException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Connection connection = this.getConnection();){
                PreparedStatement preparedStatement = connection.prepareStatement("SELECT datasource_key\nFROM {table_prefix}ai_datasource_stats\n    WHERE last_query < ?\n");
                preparedStatement.setString(1, TIMESTAMP_FMT.format(olderThan));
                ResultSet resultSet = preparedStatement.executeQuery();
                ArrayList<RAGDatasourceKey> results = new ArrayList<RAGDatasourceKey>();
                while (resultSet.next()) {
                    results.add(RAGDatasourceKey.fromString((String)resultSet.getString("datasource_key")));
                }
                return results;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Error querying stale datasources", (Throwable)e);
        }
    }

    @Override
    protected void updateDatasourceStats(@NotNull RAGDatasourceKey datasourceKey) throws DBException {
        String now = TIMESTAMP_FMT.format(Instant.now());
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Connection connection = this.getConnection();){
                PreparedStatement stmt = connection.prepareStatement("INSERT INTO {table_prefix}ai_datasource_stats (datasource_key, last_query)\n   VALUES (?, ?)\n   ON CONFLICT (datasource_key) DO UPDATE\n     SET last_query = ?\n");
                stmt.setString(1, datasourceKey.asString());
                stmt.setString(2, now);
                stmt.setString(3, now);
                stmt.execute();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Error updating datasource stats", (Throwable)e);
        }
    }

    @Override
    @NotNull
    protected RAGEmbeddedRecord extractRecord(@NotNull ResultSet resultSet) throws SQLException {
        return new RAGEmbeddedRecord(RAGObjectKey.fromString((String)resultSet.getString("object_key")), resultSet.getLong("checksum"), resultSet.getString("model_name"), RAGSQLiteEmbeddingStorage.blobToF32(resultSet.getBytes("embedding")));
    }

    @NotNull
    private static byte[] f32ToBlob(@NotNull float[] v) {
        float[] normalizedVector = RAGSQLiteEmbeddingStorage.normalizeEmbedding(v);
        ByteBuffer bb = ByteBuffer.allocate(normalizedVector.length * 4).order(ByteOrder.LITTLE_ENDIAN);
        float[] fArray = normalizedVector;
        int n = normalizedVector.length;
        int n2 = 0;
        while (n2 < n) {
            float f = fArray[n2];
            bb.putFloat(f);
            ++n2;
        }
        return bb.array();
    }

    @NotNull
    private static float[] blobToF32(@NotNull byte[] b) {
        ByteBuffer bb = ByteBuffer.wrap(b).order(ByteOrder.LITTLE_ENDIAN);
        float[] out = new float[b.length / 4];
        int i = 0;
        while (i < out.length) {
            out[i] = bb.getFloat();
            ++i;
        }
        return out;
    }

    private static /* synthetic */ String lambda$2(RAGDatasourceKey rAGDatasourceKey, String name) {
        return new RAGObjectKey(rAGDatasourceKey, name).asString();
    }
}

