/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.rag.storage.pg;

import com.dbeaver.model.ai.rag.storage.RAGDatabaseExtensionsInitializer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.connection.DBPDriver;

public class RAGPostgresExtensionsInitializer
implements RAGDatabaseExtensionsInitializer {
    private final List<String> requiredExtensions = List.of("vector");

    @Override
    public void initializeExtensions(@NotNull DBPDriver driver, @NotNull Connection connection) throws DBException {
        for (String extension : this.requiredExtensions) {
            if (!this.isExtensionAvailable(connection, extension)) {
                throw new DBException(String.format("Postgres %s extension is not available on the PostgreSQL server. Please install the %s extension files on the server side to use RAG features.", extension, extension));
            }
            this.installExtension(connection, extension);
        }
    }

    private boolean isExtensionAvailable(@NotNull Connection connection, @NotNull String extensionName) throws DBException {
        PreparedStatement stmt;
        block13: {
            boolean bl;
            block14: {
                String sql = "SELECT EXISTS (SELECT 1 FROM pg_available_extensions WHERE name = ?);";
                Throwable throwable = null;
                Object var5_7 = null;
                stmt = connection.prepareStatement(sql);
                try {
                    stmt.setString(1, extensionName);
                    ResultSet rs = stmt.executeQuery();
                    if (!rs.next()) break block13;
                    bl = rs.getBoolean(1);
                    if (stmt == null) break block14;
                }
                catch (Throwable throwable2) {
                    try {
                        try {
                            if (stmt != null) {
                                stmt.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception e) {
                        throw new DBException("Error checking PostgreSQL " + extensionName + " extension availability", (Throwable)e);
                    }
                }
                stmt.close();
            }
            return bl;
        }
        if (stmt != null) {
            stmt.close();
        }
        return false;
    }

    private void installExtension(@NotNull Connection connection, @NotNull String extensionName) throws DBException {
        String sql = String.format("CREATE EXTENSION IF NOT EXISTS %s;", extensionName);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Statement stmt = connection.createStatement();){
                stmt.execute(sql);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new DBException("Error installing PostgreSQL " + extensionName + " extension", (Throwable)e);
        }
    }

    @Override
    @NotNull
    public Map<Object, Object> getConnectionProperties(@NotNull String driver) {
        return Map.of();
    }
}

