/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.rag.storage;

import com.dbeaver.model.ai.RAGEmbeddingStorage;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.PeriodicJob;

public class RAGDatabaseCleanupJob
extends PeriodicJob {
    private static final Log log = Log.getLog(RAGDatabaseCleanupJob.class);
    private static final Duration CLEANUP_INTERVAL = Duration.ofDays(30L);
    @NotNull
    private final RAGEmbeddingStorage storage;

    public RAGDatabaseCleanupJob(@NotNull DBPPlatform platform, @NotNull RAGEmbeddingStorage storage) {
        super("RAG DB data cleanup", platform, Duration.ofDays(1L));
        this.storage = storage;
    }

    protected void doJob(@NotNull DBRProgressMonitor monitor) {
        log.debug((Object)"Starting RAG DB cleanup job");
        try {
            List staleDatasources = this.storage.findStaleDatasources(Instant.now().minus(CLEANUP_INTERVAL));
            if (staleDatasources.isEmpty()) {
                log.debug((Object)"No stale RAG datasources found");
                return;
            }
            this.storage.deleteByDatasourceIds((Collection)staleDatasources);
        }
        catch (Exception e) {
            log.error((Object)"Error during RAG DB cleanup job", (Throwable)e);
        }
    }
}

