/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.rag.storage;

import com.dbeaver.model.ai.RAGDatasourceKey;
import com.dbeaver.model.ai.RAGEmbeddedRecord;
import com.dbeaver.model.ai.RAGEmbeddingStorage;
import com.dbeaver.model.ai.RAGObjectKey;
import com.dbeaver.model.ai.RAGRelevantRecordFilter;
import com.dbeaver.model.ai.rag.storage.RAGDatabase;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;

public abstract class RAGAbstractEmbeddingStorage
implements RAGEmbeddingStorage {
    protected static final int VECTOR_DIMENSION = 1536;
    protected static final int BATCH_SIZE = 1000;
    protected final RAGDatabase ragDatabase;

    protected RAGAbstractEmbeddingStorage(RAGDatabase ragDatabase) {
        this.ragDatabase = ragDatabase;
    }

    public abstract void save(@NotNull Collection<RAGEmbeddedRecord> var1) throws DBException;

    /*
     * Exception decompiling
     */
    @NotNull
    public List<RAGEmbeddedRecord> findByKeys(@NotNull Collection<RAGObjectKey> objectKeys) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    protected List<RAGEmbeddedRecord> extractRecords(@NotNull ResultSet resultSet) throws SQLException {
        ArrayList<RAGEmbeddedRecord> records = new ArrayList<RAGEmbeddedRecord>();
        while (resultSet.next()) {
            records.add(this.extractRecord(resultSet));
        }
        return records;
    }

    @NotNull
    protected static float[] normalizeEmbedding(@NotNull float[] embedding) {
        if (embedding.length == 1536) {
            return embedding;
        }
        float[] paddedEmbedding = new float[1536];
        System.arraycopy(embedding, 0, paddedEmbedding, 0, Math.min(embedding.length, 1536));
        return paddedEmbedding;
    }

    @NotNull
    public List<RAGEmbeddedRecord> findRelevantRecords(@NotNull RAGRelevantRecordFilter filter) throws DBException {
        this.updateDatasourceStats(new RAGDatasourceKey(filter.projectId(), filter.datasourceId()));
        return this.findRelevantRecords0(filter);
    }

    protected abstract List<RAGEmbeddedRecord> findRelevantRecords0(@NotNull RAGRelevantRecordFilter var1) throws DBException;

    @NotNull
    public abstract List<RAGDatasourceKey> findStaleDatasources(@NotNull Instant var1) throws DBException;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deleteByDatasourceIds(@NotNull Collection<RAGDatasourceKey> keys) throws DBException {
        if (keys.isEmpty()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Connection connection = this.getConnection();){
                connection.setAutoCommit(false);
                try {
                    Throwable throwable2 = null;
                    Object var6_11 = null;
                    try {
                        PreparedStatement deleteIndexStmt = connection.prepareStatement("DELETE FROM {table_prefix}ai_object_index\nWHERE object_key LIKE ?\n");
                        try {
                            try (PreparedStatement deleteStatsStmt = connection.prepareStatement("DELETE FROM {table_prefix}ai_datasource_stats\nWHERE datasource_key = ?\n");){
                                for (RAGDatasourceKey key : keys) {
                                    deleteIndexStmt.setString(1, key.asString() + "%");
                                    deleteIndexStmt.addBatch();
                                    deleteStatsStmt.setString(1, key.asString());
                                    deleteStatsStmt.addBatch();
                                }
                                deleteIndexStmt.executeBatch();
                                deleteStatsStmt.executeBatch();
                                connection.commit();
                            }
                            if (deleteIndexStmt == null) return;
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            if (deleteIndexStmt == null) throw throwable2;
                            deleteIndexStmt.close();
                            throw throwable2;
                        }
                        deleteIndexStmt.close();
                        return;
                    }
                    catch (Throwable throwable4) {
                        if (throwable2 == null) {
                            throwable2 = throwable4;
                            throw throwable2;
                        } else {
                            if (throwable2 == throwable4) throw throwable2;
                            throwable2.addSuppressed(throwable4);
                        }
                        throw throwable2;
                    }
                }
                catch (SQLException e) {
                    connection.rollback();
                    throw e;
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                } else {
                    if (throwable == throwable5) throw throwable;
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Error deleting embeddings by datasource IDs", (Throwable)e);
        }
    }

    protected abstract void updateDatasourceStats(@NotNull RAGDatasourceKey var1) throws DBException;

    protected abstract RAGEmbeddedRecord extractRecord(@NotNull ResultSet var1) throws SQLException;

    @NotNull
    protected Connection getConnection() throws DBException {
        return this.ragDatabase.getDatabaseConnection();
    }
}

