/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.rag;

import com.dbeaver.model.ai.RAGStorageProvider;
import com.dbeaver.model.ai.rag.AIScopeSelector;
import com.dbeaver.model.ai.rag.NoOpScopeSelector;
import com.dbeaver.model.ai.rag.RAGScopeSelector;
import java.util.concurrent.atomic.AtomicReference;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.ai.impl.AISchemaGeneratorImpl;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.model.app.DBPWorkspace;

public class AIScopeSelectorFactory {
    private static final Log log = Log.getLog(AIScopeSelectorFactory.class);
    @NotNull
    private final DBPWorkspace workspace;
    @NotNull
    private final AISchemaGeneratorImpl schemaGenerator = new AISchemaGeneratorImpl();
    @NotNull
    private static final AtomicReference<AIScopeSelector> CACHED_SCOPE_SELECTOR = new AtomicReference();

    public AIScopeSelectorFactory(@NotNull DBPWorkspace workspace) {
        this.workspace = workspace;
    }

    public AIScopeSelector getScopeSelector() {
        return CACHED_SCOPE_SELECTOR.updateAndGet(existing -> {
            if (existing != null) {
                return existing;
            }
            return this.createScopeSelector();
        });
    }

    @NotNull
    private AIScopeSelector createScopeSelector() {
        DBPApplication dBPApplication = this.workspace.getPlatform().getApplication();
        if (dBPApplication instanceof RAGStorageProvider) {
            RAGStorageProvider ragStorageProvider = (RAGStorageProvider)dBPApplication;
            try {
                return new RAGScopeSelector(ragStorageProvider.getEmbeddingStorage(), this.schemaGenerator);
            }
            catch (Exception e) {
                log.error((Object)"Error initializing RAG scope selector", (Throwable)e);
                return new NoOpScopeSelector();
            }
        }
        log.info((Object)"RAG is not available in the current application. Using NoOpScopeSelector.");
        return new NoOpScopeSelector();
    }
}

