/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.hana.sqlgenerator;

import java.util.ArrayList;
import liquibase.database.Database;
import liquibase.ext.hana.HanaDatabase;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.CreateViewGenerator;
import liquibase.statement.core.CreateViewStatement;
import liquibase.structure.DatabaseObject;
import liquibase.util.SqlParser;
import liquibase.util.StringClauses;

public class CreateViewGeneratorHana
extends CreateViewGenerator {
    public int getPriority() {
        return 5;
    }

    public boolean supports(CreateViewStatement statement, Database database) {
        return database instanceof HanaDatabase;
    }

    public Sql[] generateSql(CreateViewStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ArrayList<UnparsedSql> sql = new ArrayList<UnparsedSql>();
        StringClauses viewDefinition = SqlParser.parse((String)statement.getSelectQuery(), (boolean)true, (boolean)true);
        if (!statement.isFullDefinition()) {
            viewDefinition.prepend(" ").prepend("AS").prepend(" ").prepend(database.escapeViewName(statement.getCatalogName(), statement.getSchemaName(), statement.getViewName())).prepend(" ").prepend("VIEW").prepend(" ").prepend("CREATE");
        }
        if (statement.isReplaceIfExists()) {
            sql.add(new UnparsedSql("DO\nBEGIN\nDECLARE EXIT HANDLER FOR SQL_ERROR_CODE 321 BEGIN END;\nEXEC 'DROP VIEW " + database.escapeStringForDatabase(database.escapeViewName(statement.getCatalogName(), statement.getSchemaName(), statement.getViewName())) + "'; \nEND--;;;", "--;;;", new DatabaseObject[]{this.getAffectedView(statement)}));
            if (viewDefinition.contains("replace")) {
                viewDefinition.replace("CREATE OR REPLACE", "CREATE");
            }
        }
        sql.add(new UnparsedSql(viewDefinition.toString(), new DatabaseObject[]{this.getAffectedView(statement)}));
        return sql.toArray(new Sql[sql.size()]);
    }
}

