/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.hana.sqlgenerator;

import liquibase.database.Database;
import liquibase.datatype.DataTypeFactory;
import liquibase.datatype.DatabaseDataType;
import liquibase.ext.hana.HanaDatabase;
import liquibase.sqlgenerator.core.AddColumnGenerator;
import liquibase.statement.AutoIncrementConstraint;
import liquibase.statement.DatabaseFunction;
import liquibase.statement.core.AddColumnStatement;

public class AddColumnGeneratorHana
extends AddColumnGenerator {
    public int getPriority() {
        return 5;
    }

    public boolean supports(AddColumnStatement statement, Database database) {
        return database instanceof HanaDatabase;
    }

    protected String generateSingleColumnSQL(AddColumnStatement statement, Database database) {
        Object defaultValue;
        DatabaseDataType columnType = DataTypeFactory.getInstance().fromDescription(statement.getColumnType() + (statement.isAutoIncrement() ? "{autoIncrement:true}" : ""), database).toDatabaseDataType(database);
        String alterTable = " ADD (" + database.escapeColumnName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), statement.getColumnName()) + " " + columnType;
        if (statement.isAutoIncrement()) {
            AutoIncrementConstraint autoIncrementConstraint = statement.getAutoIncrementConstraint();
            alterTable = alterTable + " " + database.getAutoIncrementClause(autoIncrementConstraint.getStartWith(), autoIncrementConstraint.getIncrementBy(), autoIncrementConstraint.getGenerationType(), autoIncrementConstraint.getDefaultOnNull());
        }
        if ((defaultValue = statement.getDefaultValue()) != null) {
            alterTable = defaultValue instanceof DatabaseFunction ? alterTable + " DEFAULT " + DataTypeFactory.getInstance().fromObject(defaultValue, database).objectToSql(defaultValue, database) : alterTable + " DEFAULT " + DataTypeFactory.getInstance().fromDescription(statement.getColumnType(), database).objectToSql(defaultValue, database);
        }
        if (!statement.isNullable()) {
            alterTable = alterTable + " NOT NULL";
        }
        if (statement.isPrimaryKey()) {
            alterTable = alterTable + " PRIMARY KEY";
        }
        if (statement.getRemarks() != null) {
            alterTable = alterTable + " COMMENT '" + database.escapeStringForDatabase(statement.getRemarks().trim()) + "' ";
        }
        alterTable = alterTable + ")";
        return alterTable;
    }
}

