/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.db2i.sqlgenerator;

import java.util.Date;
import liquibase.database.Database;
import liquibase.datatype.DataTypeFactory;
import liquibase.exception.LiquibaseException;
import liquibase.ext.db2i.database.DB2iDatabase;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.InsertOrUpdateGenerator;
import liquibase.sqlgenerator.core.InsertOrUpdateGeneratorDB2;
import liquibase.statement.DatabaseFunction;
import liquibase.statement.core.InsertOrUpdateStatement;

public class InsertOrUpdateGeneratorDB2i
extends InsertOrUpdateGenerator {
    public boolean supports(InsertOrUpdateStatement stmt, Database db) {
        return db instanceof DB2iDatabase;
    }

    public int getPriority() {
        return new InsertOrUpdateGeneratorDB2().getPriority() + 1;
    }

    protected String getRecordCheck(InsertOrUpdateStatement stmt, Database db, String whereClause) {
        String[] keys;
        StringBuilder sql = new StringBuilder("MERGE INTO ").append(db.escapeTableName(stmt.getCatalogName(), stmt.getSchemaName(), stmt.getTableName())).append(" AS DST ").append("USING (").append("VALUES (").append(this.getValues(stmt, db)).append(") ) AS SRC( ").append((CharSequence)this.buildColumns(stmt)).append(") ON ");
        for (String key : keys = stmt.getPrimaryKey().split(",")) {
            sql.append("DST.").append(key).append(" = SRC.").append(key).append(" AND ");
        }
        sql.delete(sql.length() - " AND ".length(), sql.length());
        sql.append(" WHEN NOT MATCHED THEN ");
        return sql.toString();
    }

    protected String getInsertStatement(InsertOrUpdateStatement stmt, Database db, SqlGeneratorChain sqlGeneratorChain) {
        StringBuilder columns = new StringBuilder();
        StringBuilder values = new StringBuilder();
        for (String columnKey : stmt.getColumnValues().keySet()) {
            columns.append(", ");
            columns.append(columnKey);
            values.append(", ");
            if (stmt.getColumnValues().get(columnKey).toString().equalsIgnoreCase("NULL")) {
                values.append("NULL");
                continue;
            }
            values.append("SRC.").append(columnKey);
        }
        columns.deleteCharAt(0);
        values.deleteCharAt(0);
        return " INSERT(" + columns.toString() + ") VALUES (" + values.toString() + ") ";
    }

    protected String getElse(Database db) {
        return " WHEN MATCHED THEN ";
    }

    protected String getUpdateStatement(InsertOrUpdateStatement stmt, Database db, String whereClause, SqlGeneratorChain sqlGeneratorChain) throws LiquibaseException {
        StringBuilder sql = new StringBuilder("UPDATE SET ");
        for (String column : stmt.getColumnValues().keySet()) {
            sql.append(" ").append(column).append(" = ").append(this.getValueAsDatabaseType(stmt.getColumnValues().get(column), db, false)).append(", ");
        }
        sql.deleteCharAt(sql.lastIndexOf(" "));
        int lastComma = sql.lastIndexOf(",");
        if (lastComma >= 0) {
            sql.deleteCharAt(lastComma);
        }
        sql.append(" ");
        return sql.toString();
    }

    private StringBuilder buildColumns(InsertOrUpdateStatement stmt) {
        StringBuilder columns = new StringBuilder();
        for (String columnKey : stmt.getColumnValues().keySet()) {
            if (stmt.getColumnValues().get(columnKey).toString().equalsIgnoreCase("NULL")) continue;
            columns.append(",");
            columns.append(columnKey);
        }
        columns.deleteCharAt(0);
        return columns;
    }

    private String getValueAsDatabaseType(Object newValue, Database db, boolean skipNullValue) {
        if (newValue == null || newValue.toString().equalsIgnoreCase("NULL")) {
            return skipNullValue ? "" : "NULL";
        }
        if (newValue instanceof String && !this.looksLikeFunctionCall((String)newValue, db)) {
            return DataTypeFactory.getInstance().fromObject(newValue, db).objectToSql(newValue, db);
        }
        if (newValue instanceof Date) {
            return db.getDateLiteral((Date)newValue);
        }
        if (newValue instanceof Boolean) {
            if (((Boolean)newValue).booleanValue()) {
                return DataTypeFactory.getInstance().getTrueBooleanValue(db);
            }
            return DataTypeFactory.getInstance().getFalseBooleanValue(db);
        }
        if (newValue instanceof DatabaseFunction) {
            return db.generateDatabaseFunctionValue((DatabaseFunction)newValue);
        }
        return newValue.toString();
    }

    private String getValues(InsertOrUpdateStatement stmt, Database db) {
        StringBuilder values = new StringBuilder();
        for (String column : stmt.getColumnValues().keySet()) {
            String newValue = this.getValueAsDatabaseType(stmt.getColumnValues().get(column), db, true);
            if (newValue == null || newValue.length() <= 0) continue;
            values.append(newValue).append(", ");
        }
        values.deleteCharAt(values.lastIndexOf(" "));
        int lastComma = values.lastIndexOf(",");
        if (lastComma >= 0) {
            values.deleteCharAt(lastComma);
        }
        return values.toString();
    }
}

