/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphEntity;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphIdentitySet;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphItemReference;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphSharingInvitation;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphSharingLink;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class MicrosoftGraphPermission
extends MicrosoftGraphEntity {
    @JsonProperty(value="expirationDateTime")
    private OffsetDateTime expirationDateTime;
    @JsonProperty(value="grantedTo")
    private MicrosoftGraphIdentitySet grantedTo;
    @JsonProperty(value="grantedToIdentities")
    private List<MicrosoftGraphIdentitySet> grantedToIdentities;
    @JsonProperty(value="hasPassword")
    private Boolean hasPassword;
    @JsonProperty(value="inheritedFrom")
    private MicrosoftGraphItemReference inheritedFrom;
    @JsonProperty(value="invitation")
    private MicrosoftGraphSharingInvitation invitation;
    @JsonProperty(value="link")
    private MicrosoftGraphSharingLink link;
    @JsonProperty(value="roles")
    private List<String> roles;
    @JsonProperty(value="shareId")
    private String shareId;
    @JsonIgnore
    private Map<String, Object> additionalProperties;

    public OffsetDateTime expirationDateTime() {
        return this.expirationDateTime;
    }

    public MicrosoftGraphPermission withExpirationDateTime(OffsetDateTime expirationDateTime) {
        this.expirationDateTime = expirationDateTime;
        return this;
    }

    public MicrosoftGraphIdentitySet grantedTo() {
        return this.grantedTo;
    }

    public MicrosoftGraphPermission withGrantedTo(MicrosoftGraphIdentitySet grantedTo) {
        this.grantedTo = grantedTo;
        return this;
    }

    public List<MicrosoftGraphIdentitySet> grantedToIdentities() {
        return this.grantedToIdentities;
    }

    public MicrosoftGraphPermission withGrantedToIdentities(List<MicrosoftGraphIdentitySet> grantedToIdentities) {
        this.grantedToIdentities = grantedToIdentities;
        return this;
    }

    public Boolean hasPassword() {
        return this.hasPassword;
    }

    public MicrosoftGraphPermission withHasPassword(Boolean hasPassword) {
        this.hasPassword = hasPassword;
        return this;
    }

    public MicrosoftGraphItemReference inheritedFrom() {
        return this.inheritedFrom;
    }

    public MicrosoftGraphPermission withInheritedFrom(MicrosoftGraphItemReference inheritedFrom) {
        this.inheritedFrom = inheritedFrom;
        return this;
    }

    public MicrosoftGraphSharingInvitation invitation() {
        return this.invitation;
    }

    public MicrosoftGraphPermission withInvitation(MicrosoftGraphSharingInvitation invitation) {
        this.invitation = invitation;
        return this;
    }

    public MicrosoftGraphSharingLink link() {
        return this.link;
    }

    public MicrosoftGraphPermission withLink(MicrosoftGraphSharingLink link) {
        this.link = link;
        return this;
    }

    public List<String> roles() {
        return this.roles;
    }

    public MicrosoftGraphPermission withRoles(List<String> roles) {
        this.roles = roles;
        return this;
    }

    public String shareId() {
        return this.shareId;
    }

    public MicrosoftGraphPermission withShareId(String shareId) {
        this.shareId = shareId;
        return this;
    }

    @Override
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphPermission withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
    }

    @Override
    public MicrosoftGraphPermission withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.grantedTo() != null) {
            this.grantedTo().validate();
        }
        if (this.grantedToIdentities() != null) {
            this.grantedToIdentities().forEach(e -> e.validate());
        }
        if (this.inheritedFrom() != null) {
            this.inheritedFrom().validate();
        }
        if (this.invitation() != null) {
            this.invitation().validate();
        }
        if (this.link() != null) {
            this.link().validate();
        }
    }
}

