/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.parquet;

import com.dbeaver.jdbc.base.ColumnInfo;
import com.dbeaver.jdbc.files.FFDataFileMetadataReader;
import com.dbeaver.jdbc.files.database.FFSQLType;
import com.dbeaver.jdbc.files.database.FFSchemaName;
import com.dbeaver.jdbc.files.database.FFTableProperties;
import com.dbeaver.jdbc.files.database.FFTableStructure;
import com.dbeaver.jdbc.files.parquet.ParquetConverter;
import com.dbeaver.jdbc.files.parquet.ParquetFileReader;
import com.dbeaver.jdbc.files.parquet.ParquetFileReaderFactory;
import com.dbeaver.jdbc.files.parquet.ParquetProperties;
import com.dbeaver.jdbc.files.parquet.ParquetTableProperties;
import com.dbeaver.jdbc.files.parquet.ParquetValue;
import com.dbeaver.jdbc.files.utils.FFIOUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;
import org.jkiss.code.NotNull;

class ParquetMetadataReader
implements FFDataFileMetadataReader<ParquetValue, ParquetTableProperties> {
    @NotNull
    private final ParquetProperties properties;
    @NotNull
    private final ParquetFileReaderFactory readerFactory;

    ParquetMetadataReader(@NotNull ParquetProperties properties, @NotNull ParquetFileReaderFactory readerFactory) {
        this.properties = properties;
        this.readerFactory = readerFactory;
    }

    @NotNull
    public FFTableStructure<ParquetValue, ParquetTableProperties> getTableStructure(@NotNull FFSchemaName schemaName, @NotNull Path dataPath, @NotNull String tableSourceName) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (ParquetFileReader reader = this.readerFactory.createReader(dataPath, this.properties);){
            MessageType schema = reader.getSchema();
            List columns = schema.getColumns();
            ArrayList<ColumnInfo> columnInfos = new ArrayList<ColumnInfo>(columns.size());
            int i = 0;
            while (i < columns.size()) {
                Type type = (Type)schema.getFields().get(i);
                FFSQLType sqlType = ParquetConverter.toSQLType(type);
                int nullable = type.getRepetition() == Type.Repetition.REQUIRED ? 0 : 1;
                columnInfos.add(i, new ColumnInfo(null, schemaName.name(), tableSourceName, schema.getFieldName(i), schema.getFieldName(i), sqlType.getVendorTypeNumber().intValue(), sqlType.getName(), -1, value -> ParquetConverter.createValueReader(type).readValue((ParquetValue)value), nullable));
                ++i;
            }
            return new FFTableStructure(columnInfos, (FFTableProperties)ParquetTableProperties.EMPTY);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @NotNull
    public List<String> getTableSourceNames(@NotNull Path dataPath) {
        return List.of(FFIOUtils.truncateFileExtension((Path)dataPath));
    }
}

